package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowControllersTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.controllers.Controller;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.controllers.ControllerKey;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.openflow.rev181121.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Container for the Openflow controllers model
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-openflow</b>
 * <pre>
 * container controllers {
 *   list controller {
 *     key name;
 *     leaf name {
 *       type leafref {
 *         path ../config/name;
 *       }
 *     }
 *     container config {
 *       uses openflow-controller-config;
 *     }
 *     container state {
 *       config false;
 *       uses openflow-controller-config;
 *       uses openflow-controller-state;
 *     }
 *     uses openflow-connections-top;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link ControllersBuilder}.
 * @see ControllersBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Controllers
    extends
    ChildOf<OpenflowControllersTop>,
    Augmentable<Controllers>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("controllers");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.Controllers> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.Controllers.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.@NonNull Controllers obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getController());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.@NonNull Controllers thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.Controllers.class, obj);
        return other != null
            && Objects.equals(thisObj.getController(), other.getController())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.@NonNull Controllers obj) {
        final var helper = MoreObjects.toStringHelper("Controllers");
        CodeHelpers.appendValue(helper, "controller", obj.getController());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return controller, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The Openflow Switch connects to all Openflow controllers configured
     *     </code>
     * </pre>
     *
     * @return {@code Map<ControllerKey, Controller>} controller, or {@code null} if it is not present.
     *
     */
    @Nullable Map<ControllerKey, Controller> getController();
    
    /**
     * Return controller, or an empty list if it is not present.
     *
     * @return {@code Map<ControllerKey, Controller>} controller, or an empty list if it is not present.
     *
     */
    default @NonNull Map<ControllerKey, Controller> nonnullController() {
        return CodeHelpers.nonnull(getController());
    }

}

