package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630.AuxiliaryId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;

/**
 * This class represents the key of {@link Connection} class.
 *
 * @see Connection
 *
 */
@Generated("mdsal-binding-generator")
public class ConnectionKey
 implements Key<Connection> {
    @java.io.Serial
    private static final long serialVersionUID = -7639725888873695426L;
    private final AuxiliaryId _auxId;


    /**
     * Constructs an instance.
     *
     * @param _auxId the entity auxId
     * @throws NullPointerException if any of the arguments are null
     */
    public ConnectionKey(@NonNull AuxiliaryId _auxId) {
        this._auxId = CodeHelpers.requireKeyProp(_auxId, "auxId");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public ConnectionKey(ConnectionKey source) {
        this._auxId = source._auxId;
    }


    /**
     * Return auxId, guaranteed to be non-null.
     *
     * @return {@code AuxiliaryId} auxId, guaranteed to be non-null.
     */
    public @NonNull AuxiliaryId getAuxId() {
        return _auxId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_auxId);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof ConnectionKey other
            && Objects.equals(_auxId, other._auxId);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(ConnectionKey.class);
        CodeHelpers.appendValue(helper, "auxId", _auxId);
        return helper.toString();
    }
}

