package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.agent.top.agent;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowAgentConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowAgentState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.agent.top.Agent;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.openflow.rev181121.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Container for the Openflow agent state.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-openflow</b>
 * <pre>
 * container state {
 *   config false;
 *   uses openflow-agent-config;
 *   uses openflow-agent-state;
 * }
 * </pre>
 * <p>To create instances of this class use {@link StateBuilder}.
 * @see StateBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface State
    extends
    ChildOf<Agent>,
    Augmentable<State>,
    OpenflowAgentConfig,
    OpenflowAgentState
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("state");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.agent.top.agent.State> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.agent.top.agent.State.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.agent.top.agent.@NonNull State obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getBackoffInterval());
        result = prime * result + Objects.hashCode(obj.getDatapathId());
        result = prime * result + Objects.hashCode(obj.getFailureMode());
        result = prime * result + Objects.hashCode(obj.getInactivityProbe());
        result = prime * result + Objects.hashCode(obj.getMaxBackoff());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.agent.top.agent.@NonNull State thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.agent.top.agent.State.class, obj);
        return other != null
            && Objects.equals(thisObj.getBackoffInterval(), other.getBackoffInterval())
            && Objects.equals(thisObj.getInactivityProbe(), other.getInactivityProbe())
            && Objects.equals(thisObj.getMaxBackoff(), other.getMaxBackoff())
            && Objects.equals(thisObj.getDatapathId(), other.getDatapathId())
            && Objects.equals(thisObj.getFailureMode(), other.getFailureMode())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.agent.top.agent.@NonNull State obj) {
        final var helper = MoreObjects.toStringHelper("State");
        CodeHelpers.appendValue(helper, "backoffInterval", obj.getBackoffInterval());
        CodeHelpers.appendValue(helper, "datapathId", obj.getDatapathId());
        CodeHelpers.appendValue(helper, "failureMode", obj.getFailureMode());
        CodeHelpers.appendValue(helper, "inactivityProbe", obj.getInactivityProbe());
        CodeHelpers.appendValue(helper, "maxBackoff", obj.getMaxBackoff());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

