package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.Connections;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.openflow.rev181121.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for OpenFlow controller connections
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-openflow</b>
 * <pre>
 * grouping openflow-connections-top {
 *   container connections {
 *     list connection {
 *       key aux-id;
 *       leaf aux-id {
 *         type leafref {
 *           path ../config/aux-id;
 *         }
 *       }
 *       container config {
 *         uses openflow-connections-config;
 *       }
 *       container state {
 *         config false;
 *         uses openflow-connections-config;
 *         uses openflow-connections-state;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenflowConnectionsTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("openflow-connections-top");

    @Override
    Class<? extends OpenflowConnectionsTop> implementedInterface();
    
    /**
     * Return connections, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container for list of controller connections
     *     </code>
     * </pre>
     *
     * @return {@code Connections} connections, or {@code null} if it is not present.
     *
     */
    Connections getConnections();
    
    /**
     * Return connections, or an empty instance if it is not present.
     *
     * @return {@code Connections} connections, or an empty instance if it is not present.
     *
     */
    @NonNull Connections nonnullConnections();

}

