package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.openflow.rev181121.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Operational state data for OpenFlow controller connections
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-openflow</b>
 * <pre>
 * grouping openflow-connections-state {
 *   leaf connected {
 *     type boolean;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenflowConnectionsState
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("openflow-connections-state");

    @Override
    Class<? extends OpenflowConnectionsState> implementedInterface();
    
    /**
     * Return connected, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         When set to true, indicates the connection between the switch and controller is
     *         established.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} connected, or {@code null} if it is not present.
     *
     */
    Boolean getConnected();
    
    /**
     * Return connected, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         When set to true, indicates the connection between the switch and controller is
     *         established.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} connected, guaranteed to be non-null.
     * @throws NoSuchElementException if connected is not present
     *
     */
    default @NonNull Boolean requireConnected() {
        return CodeHelpers.require(getConnected(), "connected");
    }

}

