package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.openconfig.types.rev190416.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Common nodes for recording average, minimum, and maximum values for a 
 * These values all have fraction-digits set to 1. Statistics are computed and 
 * reported based on a moving time interval (e.g., the last 30s). If supported by 
 * the device, the time interval over which the statistics are computed is also 
 * reported.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-types</b>
 * <pre>
 * grouping avg-min-max-stats-precision1 {
 *   leaf avg {
 *     type decimal64 {
 *       fraction-digits 1;
 *     }
 *   }
 *   leaf min {
 *     type decimal64 {
 *       fraction-digits 1;
 *     }
 *   }
 *   leaf max {
 *     type decimal64 {
 *       fraction-digits 1;
 *     }
 *   }
 *   uses stat-interval-state;
 *   uses min-max-time;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AvgMinMaxStatsPrecision1
    extends
    DataObject,
    StatIntervalState,
    MinMaxTime
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("avg-min-max-stats-precision1");

    @Override
    Class<? extends AvgMinMaxStatsPrecision1> implementedInterface();
    
    /**
     * Return avg, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The arithmetic mean value of the statistic over the time interval.
     *     </code>
     * </pre>
     *
     * @return {@code Decimal64} avg, or {@code null} if it is not present.
     *
     */
    Decimal64 getAvg();
    
    /**
     * Return avg, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The arithmetic mean value of the statistic over the time interval.
     *     </code>
     * </pre>
     *
     * @return {@code Decimal64} avg, guaranteed to be non-null.
     * @throws NoSuchElementException if avg is not present
     *
     */
    default @NonNull Decimal64 requireAvg() {
        return CodeHelpers.require(getAvg(), "avg");
    }
    
    /**
     * Return min, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The minimum value of the statistic over the time interval.
     *     </code>
     * </pre>
     *
     * @return {@code Decimal64} min, or {@code null} if it is not present.
     *
     */
    Decimal64 getMin();
    
    /**
     * Return min, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The minimum value of the statistic over the time interval.
     *     </code>
     * </pre>
     *
     * @return {@code Decimal64} min, guaranteed to be non-null.
     * @throws NoSuchElementException if min is not present
     *
     */
    default @NonNull Decimal64 requireMin() {
        return CodeHelpers.require(getMin(), "min");
    }
    
    /**
     * Return max, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum value of the statitic over the time interval.
     *     </code>
     * </pre>
     *
     * @return {@code Decimal64} max, or {@code null} if it is not present.
     *
     */
    Decimal64 getMax();
    
    /**
     * Return max, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The maximum value of the statitic over the time interval.
     *     </code>
     * </pre>
     *
     * @return {@code Decimal64} max, guaranteed to be non-null.
     * @throws NoSuchElementException if max is not present
     *
     */
    default @NonNull Decimal64 requireMax() {
        return CodeHelpers.require(getMax(), "max");
    }

}

