package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;

/**
 * This class represents the key of {@link License} class.
 *
 * @see License
 *
 */
@Generated("mdsal-binding-generator")
public class LicenseKey
 implements Key<License> {
    @java.io.Serial
    private static final long serialVersionUID = 5437473567674500922L;
    private final String _licenseId;


    /**
     * Constructs an instance.
     *
     * @param _licenseId the entity licenseId
     * @throws NullPointerException if any of the arguments are null
     */
    public LicenseKey(@NonNull String _licenseId) {
        this._licenseId = CodeHelpers.requireKeyProp(_licenseId, "licenseId");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public LicenseKey(LicenseKey source) {
        this._licenseId = source._licenseId;
    }


    /**
     * Return licenseId, guaranteed to be non-null.
     *
     * @return {@code String} licenseId, guaranteed to be non-null.
     */
    public @NonNull String getLicenseId() {
        return _licenseId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_licenseId);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof LicenseKey other
            && Objects.equals(_licenseId, other._licenseId);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(LicenseKey.class);
        CodeHelpers.appendValue(helper, "licenseId", _licenseId);
        return helper.toString();
    }
}

