package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.Licenses;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.license.rev200422.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for licenses.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-license</b>
 * <pre>
 * grouping licenses-top {
 *   container licenses {
 *     list license {
 *       key license-id;
 *       leaf license-id {
 *         type leafref {
 *           path ../config/license-id;
 *         }
 *       }
 *       container config {
 *         uses license-config;
 *       }
 *       container state {
 *         config false;
 *         uses license-config;
 *         uses license-state;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface LicensesTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("licenses-top");

    @Override
    Class<? extends LicensesTop> implementedInterface();
    
    /**
     * Return licenses, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container for list of licenses
     *     </code>
     * </pre>
     *
     * @return {@code Licenses} licenses, or {@code null} if it is not present.
     *
     */
    Licenses getLicenses();
    
    /**
     * Return licenses, or an empty instance if it is not present.
     *
     * @return {@code Licenses} licenses, or an empty instance if it is not present.
     *
     */
    @NonNull Licenses nonnullLicenses();

}

