package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406._interface.ref.state.InterfaceRef;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.interfaces.rev210406.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Reusable opstate w/container for a reference to an interface or subinterface
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-interfaces</b>
 * <pre>
 * grouping interface-ref-state {
 *   container interface-ref {
 *     uses interface-ref-state-container;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface InterfaceRefState
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("interface-ref-state");

    @Override
    Class<? extends InterfaceRefState> implementedInterface();
    
    /**
     * Return interfaceRef, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Reference to an interface or subinterface
     *     </code>
     * </pre>
     *
     * @return {@code InterfaceRef} interfaceRef, or {@code null} if it is not present.
     *
     */
    InterfaceRef getInterfaceRef();
    
    /**
     * Return interfaceRef, or an empty instance if it is not present.
     *
     * @return {@code InterfaceRef} interfaceRef, or an empty instance if it is not present.
     *
     */
    @NonNull InterfaceRef nonnullInterfaceRef();

}

