package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.ethernet;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ETHERNETSPEED;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceConfig.DuplexMode;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceState.NegotiatedDuplexMode;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state.Counters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.MacAddress;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private Boolean _autoNegotiate;
    private Counters _counters;
    private DuplexMode _duplexMode;
    private Boolean _enableFlowControl;
    private MacAddress _hwMacAddress;
    private MacAddress _macAddress;
    private NegotiatedDuplexMode _negotiatedDuplexMode;
    private ETHERNETSPEED _negotiatedPortSpeed;
    private ETHERNETSPEED _portSpeed;
    private Boolean _standaloneLinkTraining;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public StateBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link EthernetInterfaceConfig}.
     *
     * @param arg EthernetInterfaceConfig from which the builder should be initialized
     */
    public StateBuilder(EthernetInterfaceConfig arg) {
        this._macAddress = arg.getMacAddress();
        this._autoNegotiate = arg.getAutoNegotiate();
        this._standaloneLinkTraining = arg.getStandaloneLinkTraining();
        this._duplexMode = arg.getDuplexMode();
        this._portSpeed = arg.getPortSpeed();
        this._enableFlowControl = arg.getEnableFlowControl();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link EthernetInterfaceState}.
     *
     * @param arg EthernetInterfaceState from which the builder should be initialized
     */
    public StateBuilder(EthernetInterfaceState arg) {
        this._hwMacAddress = arg.getHwMacAddress();
        this._negotiatedDuplexMode = arg.getNegotiatedDuplexMode();
        this._negotiatedPortSpeed = arg.getNegotiatedPortSpeed();
        this._counters = arg.getCounters();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link State}.
     *
     * @param base State from which the builder should be initialized
     */
    public StateBuilder(State base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._autoNegotiate = base.getAutoNegotiate();
        this._counters = base.getCounters();
        this._duplexMode = base.getDuplexMode();
        this._enableFlowControl = base.getEnableFlowControl();
        this._hwMacAddress = base.getHwMacAddress();
        this._macAddress = base.getMacAddress();
        this._negotiatedDuplexMode = base.getNegotiatedDuplexMode();
        this._negotiatedPortSpeed = base.getNegotiatedPortSpeed();
        this._portSpeed = base.getPortSpeed();
        this._standaloneLinkTraining = base.getStandaloneLinkTraining();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link EthernetInterfaceConfig}</li>
     *   <li>{@link EthernetInterfaceState}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EthernetInterfaceConfig castArg) {
            this._macAddress = castArg.getMacAddress();
            this._autoNegotiate = castArg.getAutoNegotiate();
            this._standaloneLinkTraining = castArg.getStandaloneLinkTraining();
            this._duplexMode = castArg.getDuplexMode();
            this._portSpeed = castArg.getPortSpeed();
            this._enableFlowControl = castArg.getEnableFlowControl();
            isValidArg = true;
        }
        if (arg instanceof EthernetInterfaceState castArg) {
            this._hwMacAddress = castArg.getHwMacAddress();
            this._negotiatedDuplexMode = castArg.getNegotiatedDuplexMode();
            this._negotiatedPortSpeed = castArg.getNegotiatedPortSpeed();
            this._counters = castArg.getCounters();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[EthernetInterfaceConfig, EthernetInterfaceState]");
    }

    private static final class LazyEmpty {
        static final @NonNull State INSTANCE = new StateBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of State.
     *
     * @return An empty {@link State}
     */
    public static @NonNull State empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link State#getAutoNegotiate()}.
     *
     * @return current value
     */
    public Boolean getAutoNegotiate() {
        return _autoNegotiate;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getCounters()}.
     *
     * @return current value
     */
    public Counters getCounters() {
        return _counters;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getDuplexMode()}.
     *
     * @return current value
     */
    public DuplexMode getDuplexMode() {
        return _duplexMode;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getEnableFlowControl()}.
     *
     * @return current value
     */
    public Boolean getEnableFlowControl() {
        return _enableFlowControl;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getHwMacAddress()}.
     *
     * @return current value
     */
    public MacAddress getHwMacAddress() {
        return _hwMacAddress;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getMacAddress()}.
     *
     * @return current value
     */
    public MacAddress getMacAddress() {
        return _macAddress;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getNegotiatedDuplexMode()}.
     *
     * @return current value
     */
    public NegotiatedDuplexMode getNegotiatedDuplexMode() {
        return _negotiatedDuplexMode;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getNegotiatedPortSpeed()}.
     *
     * @return current value
     */
    public ETHERNETSPEED getNegotiatedPortSpeed() {
        return _negotiatedPortSpeed;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getPortSpeed()}.
     *
     * @return current value
     */
    public ETHERNETSPEED getPortSpeed() {
        return _portSpeed;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getStandaloneLinkTraining()}.
     *
     * @return current value
     */
    public Boolean getStandaloneLinkTraining() {
        return _standaloneLinkTraining;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link State#getAutoNegotiate()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setAutoNegotiate(final Boolean value) {
        this._autoNegotiate = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getCounters()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setCounters(final Counters value) {
        this._counters = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getDuplexMode()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setDuplexMode(final DuplexMode value) {
        this._duplexMode = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getEnableFlowControl()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setEnableFlowControl(final Boolean value) {
        this._enableFlowControl = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getHwMacAddress()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setHwMacAddress(final MacAddress value) {
        this._hwMacAddress = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getMacAddress()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setMacAddress(final MacAddress value) {
        this._macAddress = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getNegotiatedDuplexMode()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setNegotiatedDuplexMode(final NegotiatedDuplexMode value) {
        this._negotiatedDuplexMode = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getNegotiatedPortSpeed()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setNegotiatedPortSpeed(final ETHERNETSPEED value) {
        this._negotiatedPortSpeed = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getPortSpeed()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setPortSpeed(final ETHERNETSPEED value) {
        this._portSpeed = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getStandaloneLinkTraining()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setStandaloneLinkTraining(final Boolean value) {
        this._standaloneLinkTraining = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final Boolean _autoNegotiate;
        private final Counters _counters;
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceConfig.DuplexMode _duplexMode;
        private final Boolean _enableFlowControl;
        private final MacAddress _hwMacAddress;
        private final MacAddress _macAddress;
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceState.NegotiatedDuplexMode _negotiatedDuplexMode;
        private final ETHERNETSPEED _negotiatedPortSpeed;
        private final ETHERNETSPEED _portSpeed;
        private final Boolean _standaloneLinkTraining;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._autoNegotiate = base.getAutoNegotiate();
            this._counters = base.getCounters();
            this._duplexMode = base.getDuplexMode();
            this._enableFlowControl = base.getEnableFlowControl();
            this._hwMacAddress = base.getHwMacAddress();
            this._macAddress = base.getMacAddress();
            this._negotiatedDuplexMode = base.getNegotiatedDuplexMode();
            this._negotiatedPortSpeed = base.getNegotiatedPortSpeed();
            this._portSpeed = base.getPortSpeed();
            this._standaloneLinkTraining = base.getStandaloneLinkTraining();
        }
    
        @Override
        public Boolean getAutoNegotiate() {
            return _autoNegotiate;
        }
        
        @Override
        public Counters getCounters() {
            return _counters;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceConfig.DuplexMode getDuplexMode() {
            return _duplexMode;
        }
        
        @Override
        public Boolean getEnableFlowControl() {
            return _enableFlowControl;
        }
        
        @Override
        public MacAddress getHwMacAddress() {
            return _hwMacAddress;
        }
        
        @Override
        public MacAddress getMacAddress() {
            return _macAddress;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.EthernetInterfaceState.NegotiatedDuplexMode getNegotiatedDuplexMode() {
            return _negotiatedDuplexMode;
        }
        
        @Override
        public ETHERNETSPEED getNegotiatedPortSpeed() {
            return _negotiatedPortSpeed;
        }
        
        @Override
        public ETHERNETSPEED getPortSpeed() {
            return _portSpeed;
        }
        
        @Override
        public Boolean getStandaloneLinkTraining() {
            return _standaloneLinkTraining;
        }
    
        
        @Override
        public Counters nonnullCounters() {
            return Objects.requireNonNullElse(getCounters(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state.CountersBuilder.empty());
        }
        
        
        
        
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
