package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet.top.Ethernet;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * top-level Ethernet config and state containers
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-if-ethernet</b>
 * <pre>
 * grouping ethernet-top {
 *   container ethernet {
 *     container config {
 *       uses ethernet-interface-config;
 *     }
 *     container state {
 *       config false;
 *       uses ethernet-interface-config;
 *       uses ethernet-interface-state;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface EthernetTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("ethernet-top");

    @Override
    Class<? extends EthernetTop> implementedInterface();
    
    /**
     * Return ethernet, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for ethernet configuration and state
     *     </code>
     * </pre>
     *
     * @return {@code Ethernet} ethernet, or {@code null} if it is not present.
     *
     */
    Ethernet getEthernet();
    
    /**
     * Return ethernet, or an empty instance if it is not present.
     *
     * @return {@code Ethernet} ethernet, or an empty instance if it is not present.
     *
     */
    @NonNull Ethernet nonnullEthernet();

}

