package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.types.rev181121;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.alarms.types.rev181121.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Indicates that a service affecting condition has developed and an urgent 
 * corrective action is required. Such a severity can be reported, for example, 
 * when there is a severe degradation in the capability of the resource and its 
 * full capability must be restored.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-alarm-types</b>
 * <pre>
 * identity MAJOR {
 *   base OPENCONFIG_ALARM_SEVERITY;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface MAJOR
    extends
    OPENCONFIGALARMSEVERITY
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("MAJOR");
    /**
     * Singleton value representing the {@link MAJOR} identity.
     */
    public static final @NonNull MAJOR VALUE = new MAJOR() {
        @Override
        public Class<MAJOR> implementedInterface() {
            return MAJOR.class;
        }
    
        @Override
        public int hashCode() {
            return MAJOR.class.hashCode();
        }
    
        @Override
        public boolean equals(final Object obj) {
            return obj == this || obj instanceof MAJOR other
                && MAJOR.class.equals(other.implementedInterface());
        }
    
        @Override
        public String toString() {
            return MoreObjects.toStringHelper("MAJOR").add("qname", QNAME).toString();
        }
    };

    @Override
    Class<? extends MAJOR> implementedInterface();

}

