package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;

/**
 * This class represents the key of {@link Alarm} class.
 *
 * @see Alarm
 *
 */
@Generated("mdsal-binding-generator")
public class AlarmKey
 implements Key<Alarm> {
    @java.io.Serial
    private static final long serialVersionUID = 4176630330929901368L;
    private final String _id;


    /**
     * Constructs an instance.
     *
     * @param _id the entity id
     * @throws NullPointerException if any of the arguments are null
     */
    public AlarmKey(@NonNull String _id) {
        this._id = CodeHelpers.requireKeyProp(_id, "id");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public AlarmKey(AlarmKey source) {
        this._id = source._id;
    }


    /**
     * Return id, guaranteed to be non-null.
     *
     * @return {@code String} id, guaranteed to be non-null.
     */
    public @NonNull String getId() {
        return _id;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_id);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof AlarmKey other
            && Objects.equals(_id, other._id);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(AlarmKey.class);
        CodeHelpers.appendValue(helper, "id", _id);
        return helper.toString();
    }
}

