package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaServergroupCommonTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top.server.groups.ServerGroup;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top.server.groups.ServerGroupKey;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.aaa.rev200730.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container for AAA server groups
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * container server-groups {
 *   list server-group {
 *     key name;
 *     leaf name {
 *       type leafref {
 *         path ../config/name;
 *       }
 *     }
 *     container config {
 *       uses aaa-servergroup-common-config;
 *     }
 *     container state {
 *       config false;
 *       uses aaa-servergroup-common-config;
 *       uses aaa-servergroup-common-state;
 *     }
 *     uses aaa-server-top;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link ServerGroupsBuilder}.
 * @see ServerGroupsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface ServerGroups
    extends
    ChildOf<AaaServergroupCommonTop>,
    Augmentable<ServerGroups>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("server-groups");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top.ServerGroups> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top.ServerGroups.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top.@NonNull ServerGroups obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getServerGroup());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top.@NonNull ServerGroups thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top.ServerGroups.class, obj);
        return other != null
            && Objects.equals(thisObj.getServerGroup(), other.getServerGroup())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top.@NonNull ServerGroups obj) {
        final var helper = MoreObjects.toStringHelper("ServerGroups");
        CodeHelpers.appendValue(helper, "serverGroup", obj.getServerGroup());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return serverGroup, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of AAA server groups. All servers in a group must have the same type as
     *         indicated by the server type.
     *     </code>
     * </pre>
     *
     * @return {@code Map<ServerGroupKey, ServerGroup>} serverGroup, or {@code null} if it is not present.
     *
     */
    @Nullable Map<ServerGroupKey, ServerGroup> getServerGroup();
    
    /**
     * Return serverGroup, or an empty list if it is not present.
     *
     * @return {@code Map<ServerGroupKey, ServerGroup>} serverGroup, or an empty list if it is not present.
     *
     */
    default @NonNull Map<ServerGroupKey, ServerGroup> nonnullServerGroup() {
        return CodeHelpers.nonnull(getServerGroup());
    }

}

