package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.accounting.events.top.events;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.AAAACCOUNTINGEVENTTYPE;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;

/**
 * This class represents the key of {@link Event} class.
 *
 * @see Event
 *
 */
@Generated("mdsal-binding-generator")
public class EventKey
 implements Key<Event> {
    @java.io.Serial
    private static final long serialVersionUID = -7836264889694592572L;
    private final AAAACCOUNTINGEVENTTYPE _eventType;


    /**
     * Constructs an instance.
     *
     * @param _eventType the entity eventType
     * @throws NullPointerException if any of the arguments are null
     */
    public EventKey(@NonNull AAAACCOUNTINGEVENTTYPE _eventType) {
        this._eventType = CodeHelpers.requireKeyProp(_eventType, "eventType");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public EventKey(EventKey source) {
        this._eventType = source._eventType;
    }


    /**
     * Return eventType, guaranteed to be non-null.
     *
     * @return {@code AAAACCOUNTINGEVENTTYPE} eventType, guaranteed to be non-null.
     */
    public @NonNull AAAACCOUNTINGEVENTTYPE getEventType() {
        return _eventType;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_eventType);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof EventKey other
            && Objects.equals(_eventType, other._eventType);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(EventKey.class);
        CodeHelpers.appendValue(helper, "eventType", _eventType);
        return helper.toString();
    }
}

