package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top.Aaa;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.aaa.rev200730.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for AAA services
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-top {
 *   container aaa {
 *     container config {
 *       uses aaa-config;
 *     }
 *     container state {
 *       config false;
 *       uses aaa-config;
 *       uses aaa-state;
 *     }
 *     uses aaa-authentication-top;
 *     uses aaa-authorization-top;
 *     uses aaa-accounting-top;
 *     uses aaa-servergroup-common-top;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("aaa-top");

    @Override
    Class<? extends AaaTop> implementedInterface();
    
    /**
     * Return aaa, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for AAA services
     *     </code>
     * </pre>
     *
     * @return {@code Aaa} aaa, or {@code null} if it is not present.
     *
     */
    Aaa getAaa();
    
    /**
     * Return aaa, or an empty instance if it is not present.
     *
     * @return {@code Aaa} aaa, or an empty instance if it is not present.
     *
     */
    @NonNull Aaa nonnullAaa();

}

