package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.tacacs.server.top.Tacacs;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.aaa.rev200730.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for TACACS+ sever data
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-tacacs-server-top {
 *   container tacacs {
 *     container config {
 *       uses aaa-tacacs-server-config;
 *     }
 *     container state {
 *       config false;
 *       uses aaa-tacacs-server-config;
 *       uses aaa-tacacs-server-state;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaTacacsServerTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("aaa-tacacs-server-top");

    @Override
    Class<? extends AaaTacacsServerTop> implementedInterface();
    
    /**
     * Return tacacs, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for TACACS+ server data
     *     </code>
     * </pre>
     *
     * @return {@code Tacacs} tacacs, or {@code null} if it is not present.
     *
     */
    Tacacs getTacacs();
    
    /**
     * Return tacacs, or an empty instance if it is not present.
     *
     * @return {@code Tacacs} tacacs, or an empty instance if it is not present.
     *
     */
    @NonNull Tacacs nonnullTacacs();

}

