package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.CryptPasswordType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.RoutingPassword;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.aaa.rev200730.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Configuration data for a RADIUS server
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-radius-server-config {
 *   leaf auth-port {
 *     type oc-inet:port-number;
 *     default 1812;
 *   }
 *   leaf acct-port {
 *     type oc-inet:port-number;
 *     default 1813;
 *   }
 *   leaf secret-key {
 *     type oc-types:routing-password;
 *   }
 *   leaf secret-key-hashed {
 *     type oc-aaa-types:crypt-password-type;
 *   }
 *   leaf source-address {
 *     type oc-inet:ip-address;
 *   }
 *   leaf retransmit-attempts {
 *     type uint8;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaRadiusServerConfig
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("aaa-radius-server-config");

    @Override
    Class<? extends AaaRadiusServerConfig> implementedInterface();
    
    /**
     * Return authPort, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Port number for authentication requests
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} authPort, or {@code null} if it is not present.
     *
     */
    PortNumber getAuthPort();
    
    /**
     * Return authPort, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Port number for authentication requests
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} authPort, guaranteed to be non-null.
     * @throws NoSuchElementException if authPort is not present
     *
     */
    default @NonNull PortNumber requireAuthPort() {
        return CodeHelpers.require(getAuthPort(), "authport");
    }
    
    /**
     * Return acctPort, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Port number for accounting requests
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} acctPort, or {@code null} if it is not present.
     *
     */
    PortNumber getAcctPort();
    
    /**
     * Return acctPort, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Port number for accounting requests
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} acctPort, guaranteed to be non-null.
     * @throws NoSuchElementException if acctPort is not present
     *
     */
    default @NonNull PortNumber requireAcctPort() {
        return CodeHelpers.require(getAcctPort(), "acctport");
    }
    
    /**
     * Return secretKey, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The unencrypted shared key used between the authentication server and the
     *         device.
     *     </code>
     * </pre>
     *
     * @return {@code RoutingPassword} secretKey, or {@code null} if it is not present.
     *
     */
    RoutingPassword getSecretKey();
    
    /**
     * Return secretKey, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The unencrypted shared key used between the authentication server and the
     *         device.
     *     </code>
     * </pre>
     *
     * @return {@code RoutingPassword} secretKey, guaranteed to be non-null.
     * @throws NoSuchElementException if secretKey is not present
     *
     */
    default @NonNull RoutingPassword requireSecretKey() {
        return CodeHelpers.require(getSecretKey(), "secretkey");
    }
    
    /**
     * Return secretKeyHashed, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The hashed shared key used between the authentication server and the device.
     *     </code>
     * </pre>
     *
     * @return {@code CryptPasswordType} secretKeyHashed, or {@code null} if it is not present.
     *
     */
    CryptPasswordType getSecretKeyHashed();
    
    /**
     * Return secretKeyHashed, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The hashed shared key used between the authentication server and the device.
     *     </code>
     * </pre>
     *
     * @return {@code CryptPasswordType} secretKeyHashed, guaranteed to be non-null.
     * @throws NoSuchElementException if secretKeyHashed is not present
     *
     */
    default @NonNull CryptPasswordType requireSecretKeyHashed() {
        return CodeHelpers.require(getSecretKeyHashed(), "secretkeyhashed");
    }
    
    /**
     * Return sourceAddress, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Source IP address to use in messages to the RADIUS server
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} sourceAddress, or {@code null} if it is not present.
     *
     */
    IpAddress getSourceAddress();
    
    /**
     * Return sourceAddress, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Source IP address to use in messages to the RADIUS server
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} sourceAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if sourceAddress is not present
     *
     */
    default @NonNull IpAddress requireSourceAddress() {
        return CodeHelpers.require(getSourceAddress(), "sourceaddress");
    }
    
    /**
     * Return retransmitAttempts, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Number of times the system may resend a request to the RADIUS server when it is
     *         unresponsive
     *     </code>
     * </pre>
     *
     * @return {@code Uint8} retransmitAttempts, or {@code null} if it is not present.
     *
     */
    Uint8 getRetransmitAttempts();
    
    /**
     * Return retransmitAttempts, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Number of times the system may resend a request to the RADIUS server when it is
     *         unresponsive
     *     </code>
     * </pre>
     *
     * @return {@code Uint8} retransmitAttempts, guaranteed to be non-null.
     * @throws NoSuchElementException if retransmitAttempts is not present
     *
     */
    default @NonNull Uint8 requireRetransmitAttempts() {
        return CodeHelpers.require(getRetransmitAttempts(), "retransmitattempts");
    }

}

