package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.AAAAUTHORIZATIONEVENTTYPE;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.aaa.rev200730.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for AAA authorization events
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-authorization-events-config {
 *   leaf event-type {
 *     type identityref {
 *       base AAA_AUTHORIZATION_EVENT_TYPE;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaAuthorizationEventsConfig
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("aaa-authorization-events-config");

    @Override
    Class<? extends AaaAuthorizationEventsConfig> implementedInterface();
    
    /**
     * Return eventType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The type of event to record at the AAA authorization server
     *     </code>
     * </pre>
     *
     * @return {@code AAAAUTHORIZATIONEVENTTYPE} eventType, or {@code null} if it is not present.
     *
     */
    AAAAUTHORIZATIONEVENTTYPE getEventType();
    
    /**
     * Return eventType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The type of event to record at the AAA authorization server
     *     </code>
     * </pre>
     *
     * @return {@code AAAAUTHORIZATIONEVENTTYPE} eventType, guaranteed to be non-null.
     * @throws NoSuchElementException if eventType is not present
     *
     */
    default @NonNull AAAAUTHORIZATIONEVENTTYPE requireEventType() {
        return CodeHelpers.require(getEventType(), "eventtype");
    }

}

