package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.CryptPasswordType;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.aaa.rev200730.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for the system built-in administrator / root user account
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-admin-config {
 *   leaf admin-password {
 *     type string;
 *     oc-ext:openconfig-hashed-value;
 *   }
 *   leaf admin-password-hashed {
 *     type oc-aaa-types:crypt-password-type;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaAdminConfig
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("aaa-admin-config");

    @Override
    Class<? extends AaaAdminConfig> implementedInterface();
    
    /**
     * Return adminPassword, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The admin/root password, supplied as a cleartext string. The system should hash
     *         and only store the password as a hashed value.
     *     </code>
     * </pre>
     *
     * @return {@code String} adminPassword, or {@code null} if it is not present.
     *
     */
    String getAdminPassword();
    
    /**
     * Return adminPassword, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The admin/root password, supplied as a cleartext string. The system should hash
     *         and only store the password as a hashed value.
     *     </code>
     * </pre>
     *
     * @return {@code String} adminPassword, guaranteed to be non-null.
     * @throws NoSuchElementException if adminPassword is not present
     *
     */
    default @NonNull String requireAdminPassword() {
        return CodeHelpers.require(getAdminPassword(), "adminpassword");
    }
    
    /**
     * Return adminPasswordHashed, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The admin/root password, supplied as a hashed value using the notation described
     *         in the definition of the crypt-password-type.
     *     </code>
     * </pre>
     *
     * @return {@code CryptPasswordType} adminPasswordHashed, or {@code null} if it is not present.
     *
     */
    CryptPasswordType getAdminPasswordHashed();
    
    /**
     * Return adminPasswordHashed, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The admin/root password, supplied as a hashed value using the notation described
     *         in the definition of the crypt-password-type.
     *     </code>
     * </pre>
     *
     * @return {@code CryptPasswordType} adminPasswordHashed, guaranteed to be non-null.
     * @throws NoSuchElementException if adminPasswordHashed is not present
     *
     */
    default @NonNull CryptPasswordType requireAdminPasswordHashed() {
        return CodeHelpers.require(getAdminPasswordHashed(), "adminpasswordhashed");
    }

}

