package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.accounting.events.top.Events;
import org.opendaylight.yang.svc.v1.http.openconfig.net.yang.aaa.rev200730.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for accounting events
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-accounting-events-top {
 *   container events {
 *     list event {
 *       key event-type;
 *       leaf event-type {
 *         type leafref {
 *           path ../config/event-type;
 *         }
 *       }
 *       container config {
 *         uses aaa-accounting-events-config;
 *       }
 *       container state {
 *         config false;
 *         uses aaa-accounting-events-config;
 *         uses aaa-accounting-events-state;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaAccountingEventsTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("aaa-accounting-events-top");

    @Override
    Class<? extends AaaAccountingEventsTop> implementedInterface();
    
    /**
     * Return events, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container for defining handling of events for accounting
     *     </code>
     * </pre>
     *
     * @return {@code Events} events, or {@code null} if it is not present.
     *
     */
    Events getEvents();
    
    /**
     * Return events, or an empty instance if it is not present.
     *
     * @return {@code Events} events, or an empty instance if it is not present.
     *
     */
    @NonNull Events nonnullEvents();

}

