/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanMembersState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.members.state.Members;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.members.state.MembersBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.Vlan;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.VlanKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.vlan.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.vlan.ConfigBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.vlan.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.top.vlans.vlan.StateBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VlanBuilder {
    private Config _config;
    private Members _members;
    private State _state;
    private VlanId _vlanId;
    private VlanKey key;
    Map<Class<? extends Augmentation<Vlan>>, Augmentation<Vlan>> augmentation = Map.of();

    public VlanBuilder() {
    }

    public VlanBuilder(VlanMembersState arg) {
        this._members = arg.getMembers();
    }

    public VlanBuilder(Vlan base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Vlan>>, Augmentation<Vlan>>(aug);
        }
        this.key = base.key();
        this._vlanId = base.getVlanId();
        this._config = base.getConfig();
        this._members = base.getMembers();
        this._state = base.getState();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanMembersState) {
            VlanMembersState castArg = (VlanMembersState)arg;
            this._members = castArg.getMembers();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[VlanMembersState]");
    }

    public VlanKey key() {
        return this.key;
    }

    public Config getConfig() {
        return this._config;
    }

    public Members getMembers() {
        return this._members;
    }

    public State getState() {
        return this._state;
    }

    public VlanId getVlanId() {
        return this._vlanId;
    }

    public <E$$ extends Augmentation<Vlan>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public VlanBuilder withKey(VlanKey key) {
        this.key = key;
        return this;
    }

    public VlanBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public VlanBuilder setMembers(Members value) {
        this._members = value;
        return this;
    }

    public VlanBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public VlanBuilder setVlanId(VlanId value) {
        this._vlanId = value;
        return this;
    }

    public VlanBuilder addAugmentation(Augmentation<Vlan> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Vlan>>, Augmentation<Vlan>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public VlanBuilder removeAugmentation(Class<? extends Augmentation<Vlan>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Vlan build() {
        return new VlanImpl(this);
    }

    private static final class VlanImpl
    extends AbstractAugmentable<Vlan>
    implements Vlan {
        private final Config _config;
        private final Members _members;
        private final State _state;
        private final VlanId _vlanId;
        private final VlanKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        VlanImpl(VlanBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new VlanKey(base.getVlanId());
            this._vlanId = this.key.getVlanId();
            this._config = base.getConfig();
            this._members = base.getMembers();
            this._state = base.getState();
        }

        @Override
        public VlanKey key() {
            return this.key;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public Members getMembers() {
            return this._members;
        }

        @Override
        public State getState() {
            return this._state;
        }

        @Override
        public VlanId getVlanId() {
            return this._vlanId;
        }

        @Override
        public Config nonnullConfig() {
            return Objects.requireNonNullElse(this.getConfig(), ConfigBuilder.empty());
        }

        @Override
        public Members nonnullMembers() {
            return Objects.requireNonNullElse(this.getMembers(), MembersBuilder.empty());
        }

        @Override
        public State nonnullState() {
            return Objects.requireNonNullElse(this.getState(), StateBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Vlan.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Vlan.bindingEquals(this, obj);
        }

        public String toString() {
            return Vlan.bindingToString(this);
        }
    }
}

