/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.types.rev200630;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class AuxiliaryId
implements ScalarTypeObject<Uint8>,
Serializable {
    private static final long serialVersionUID = -7703843254594446856L;
    private final Uint8 _value;

    private static void check_valueRange(short value) {
        if (value <= 15) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..15]]", (int)value);
    }

    @ConstructorParameters(value={"value"})
    public AuxiliaryId(Uint8 _value) {
        if (_value != null) {
            AuxiliaryId.check_valueRange(_value.shortValue());
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public AuxiliaryId(AuxiliaryId source) {
        this._value = source._value;
    }

    public static AuxiliaryId getDefaultInstance(String defaultValue) {
        return new AuxiliaryId(Uint8.valueOf((String)defaultValue));
    }

    public Uint8 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof AuxiliaryId)) return false;
        AuxiliaryId other = (AuxiliaryId)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(AuxiliaryId.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

