/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.top;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowAgentTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowControllersTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.agent.top.Agent;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.agent.top.AgentBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.Controllers;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.ControllersBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.top.Openflow;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OpenflowBuilder {
    private Agent _agent;
    private Controllers _controllers;
    Map<Class<? extends Augmentation<Openflow>>, Augmentation<Openflow>> augmentation = Map.of();

    public OpenflowBuilder() {
    }

    public OpenflowBuilder(OpenflowControllersTop arg) {
        this._controllers = arg.getControllers();
    }

    public OpenflowBuilder(OpenflowAgentTop arg) {
        this._agent = arg.getAgent();
    }

    public OpenflowBuilder(Openflow base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Openflow>>, Augmentation<Openflow>>(aug);
        }
        this._agent = base.getAgent();
        this._controllers = base.getControllers();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof OpenflowControllersTop) {
            castArg = (OpenflowControllersTop)arg;
            this._controllers = castArg.getControllers();
            isValidArg = true;
        }
        if (arg instanceof OpenflowAgentTop) {
            castArg = (OpenflowAgentTop)arg;
            this._agent = castArg.getAgent();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[OpenflowControllersTop, OpenflowAgentTop]");
    }

    public static @NonNull Openflow empty() {
        return LazyEmpty.INSTANCE;
    }

    public Agent getAgent() {
        return this._agent;
    }

    public Controllers getControllers() {
        return this._controllers;
    }

    public <E$$ extends Augmentation<Openflow>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public OpenflowBuilder setAgent(Agent value) {
        this._agent = value;
        return this;
    }

    public OpenflowBuilder setControllers(Controllers value) {
        this._controllers = value;
        return this;
    }

    public OpenflowBuilder addAugmentation(Augmentation<Openflow> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Openflow>>, Augmentation<Openflow>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public OpenflowBuilder removeAugmentation(Class<? extends Augmentation<Openflow>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Openflow build() {
        return new OpenflowImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Openflow INSTANCE = new OpenflowBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class OpenflowImpl
    extends AbstractAugmentable<Openflow>
    implements Openflow {
        private final Agent _agent;
        private final Controllers _controllers;
        private int hash = 0;
        private volatile boolean hashValid = false;

        OpenflowImpl(OpenflowBuilder base) {
            super(base.augmentation);
            this._agent = base.getAgent();
            this._controllers = base.getControllers();
        }

        @Override
        public Agent getAgent() {
            return this._agent;
        }

        @Override
        public Controllers getControllers() {
            return this._controllers;
        }

        @Override
        public Agent nonnullAgent() {
            return Objects.requireNonNullElse(this.getAgent(), AgentBuilder.empty());
        }

        @Override
        public Controllers nonnullControllers() {
            return Objects.requireNonNullElse(this.getControllers(), ControllersBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Openflow.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Openflow.bindingEquals(this, obj);
        }

        public String toString() {
            return Openflow.bindingToString(this);
        }
    }
}

