/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.interfaces.top.interfaces._interface;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.InterfaceCommonConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.InterfacePhysConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.interfaces.top.interfaces._interface.Config;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev180220.InterfaceType;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

public class ConfigBuilder {
    private String _description;
    private Boolean _enabled;
    private Boolean _loopbackMode;
    private Uint16 _mtu;
    private String _name;
    private InterfaceType _type;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    public ConfigBuilder() {
    }

    public ConfigBuilder(InterfacePhysConfig arg) {
        this._name = arg.getName();
        this._type = arg.getType();
        this._mtu = arg.getMtu();
        this._loopbackMode = arg.getLoopbackMode();
        this._description = arg.getDescription();
        this._enabled = arg.getEnabled();
    }

    public ConfigBuilder(InterfaceCommonConfig arg) {
        this._description = arg.getDescription();
        this._enabled = arg.getEnabled();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._description = base.getDescription();
        this._enabled = base.getEnabled();
        this._loopbackMode = base.getLoopbackMode();
        this._mtu = base.getMtu();
        this._name = base.getName();
        this._type = base.getType();
    }

    public void fieldsFrom(DataObject arg) {
        InterfaceCommonConfig castArg;
        boolean isValidArg = false;
        if (arg instanceof InterfaceCommonConfig) {
            castArg = (InterfaceCommonConfig)arg;
            this._description = castArg.getDescription();
            this._enabled = castArg.getEnabled();
            isValidArg = true;
        }
        if (arg instanceof InterfacePhysConfig) {
            castArg = (InterfacePhysConfig)arg;
            this._name = castArg.getName();
            this._type = castArg.getType();
            this._mtu = castArg.getMtu();
            this._loopbackMode = castArg.getLoopbackMode();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[InterfaceCommonConfig, InterfacePhysConfig]");
    }

    public static @NonNull Config empty() {
        return LazyEmpty.INSTANCE;
    }

    public String getDescription() {
        return this._description;
    }

    public Boolean getEnabled() {
        return this._enabled;
    }

    public Boolean getLoopbackMode() {
        return this._loopbackMode;
    }

    public Uint16 getMtu() {
        return this._mtu;
    }

    public String getName() {
        return this._name;
    }

    public InterfaceType getType() {
        return this._type;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    public ConfigBuilder setEnabled(Boolean value) {
        this._enabled = value;
        return this;
    }

    public ConfigBuilder setLoopbackMode(Boolean value) {
        this._loopbackMode = value;
        return this;
    }

    public ConfigBuilder setMtu(Uint16 value) {
        this._mtu = value;
        return this;
    }

    public ConfigBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ConfigBuilder setType(InterfaceType value) {
        this._type = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Config INSTANCE = new ConfigBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final String _description;
        private final Boolean _enabled;
        private final Boolean _loopbackMode;
        private final Uint16 _mtu;
        private final String _name;
        private final InterfaceType _type;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._description = base.getDescription();
            this._enabled = base.getEnabled();
            this._loopbackMode = base.getLoopbackMode();
            this._mtu = base.getMtu();
            this._name = base.getName();
            this._type = base.getType();
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public Boolean getEnabled() {
            return this._enabled;
        }

        @Override
        public Boolean getLoopbackMode() {
            return this._loopbackMode;
        }

        @Override
        public Uint16 getMtu() {
            return this._mtu;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public InterfaceType getType() {
            return this._type;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

