/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.aggregation.logical.top;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.aggregation.logical.top.Aggregation;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.aggregation.logical.top.aggregation.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.aggregation.logical.top.aggregation.ConfigBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.aggregation.logical.top.aggregation.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.aggregation.logical.top.aggregation.StateBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class AggregationBuilder {
    private Config _config;
    private State _state;
    Map<Class<? extends Augmentation<Aggregation>>, Augmentation<Aggregation>> augmentation = Map.of();

    public AggregationBuilder() {
    }

    public AggregationBuilder(Aggregation base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Aggregation>>, Augmentation<Aggregation>>(aug);
        }
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public static @NonNull Aggregation empty() {
        return LazyEmpty.INSTANCE;
    }

    public Config getConfig() {
        return this._config;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Aggregation>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public AggregationBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public AggregationBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public AggregationBuilder addAugmentation(Augmentation<Aggregation> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Aggregation>>, Augmentation<Aggregation>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public AggregationBuilder removeAugmentation(Class<? extends Augmentation<Aggregation>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Aggregation build() {
        return new AggregationImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Aggregation INSTANCE = new AggregationBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class AggregationImpl
    extends AbstractAugmentable<Aggregation>
    implements Aggregation {
        private final Config _config;
        private final State _state;
        private int hash = 0;
        private volatile boolean hashValid = false;

        AggregationImpl(AggregationBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public State getState() {
            return this._state;
        }

        @Override
        public Config nonnullConfig() {
            return Objects.requireNonNullElse(this.getConfig(), ConfigBuilder.empty());
        }

        @Override
        public State nonnullState() {
            return Objects.requireNonNullElse(this.getState(), StateBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Aggregation.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Aggregation.bindingEquals(this, obj);
        }

        public String toString() {
            return Aggregation.bindingToString(this);
        }
    }
}

