/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

public class ConfigBuilder {
    private IpAddress _address;
    private String _name;
    private Uint16 _timeout;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    public ConfigBuilder() {
    }

    public ConfigBuilder(AaaServerConfig arg) {
        this._name = arg.getName();
        this._address = arg.getAddress();
        this._timeout = arg.getTimeout();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._address = base.getAddress();
        this._name = base.getName();
        this._timeout = base.getTimeout();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaServerConfig) {
            AaaServerConfig castArg = (AaaServerConfig)arg;
            this._name = castArg.getName();
            this._address = castArg.getAddress();
            this._timeout = castArg.getTimeout();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[AaaServerConfig]");
    }

    public static @NonNull Config empty() {
        return LazyEmpty.INSTANCE;
    }

    public IpAddress getAddress() {
        return this._address;
    }

    public String getName() {
        return this._name;
    }

    public Uint16 getTimeout() {
        return this._timeout;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setAddress(IpAddress value) {
        this._address = value;
        return this;
    }

    public ConfigBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ConfigBuilder setTimeout(Uint16 value) {
        this._timeout = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Config INSTANCE = new ConfigBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final IpAddress _address;
        private final String _name;
        private final Uint16 _timeout;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._address = base.getAddress();
            this._name = base.getName();
            this._timeout = base.getTimeout();
        }

        @Override
        public IpAddress getAddress() {
            return this._address;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Uint16 getTimeout() {
            return this._timeout;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

