/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.single.tagged.range;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanLogicalSingleTaggedRangeConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.single.tagged.range.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder {
    private VlanId _highVlanId;
    private VlanId _lowVlanId;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    public ConfigBuilder() {
    }

    public ConfigBuilder(VlanLogicalSingleTaggedRangeConfig arg) {
        this._lowVlanId = arg.getLowVlanId();
        this._highVlanId = arg.getHighVlanId();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._highVlanId = base.getHighVlanId();
        this._lowVlanId = base.getLowVlanId();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanLogicalSingleTaggedRangeConfig) {
            VlanLogicalSingleTaggedRangeConfig castArg = (VlanLogicalSingleTaggedRangeConfig)arg;
            this._lowVlanId = castArg.getLowVlanId();
            this._highVlanId = castArg.getHighVlanId();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[VlanLogicalSingleTaggedRangeConfig]");
    }

    public static @NonNull Config empty() {
        return LazyEmpty.INSTANCE;
    }

    public VlanId getHighVlanId() {
        return this._highVlanId;
    }

    public VlanId getLowVlanId() {
        return this._lowVlanId;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setHighVlanId(VlanId value) {
        this._highVlanId = value;
        return this;
    }

    public ConfigBuilder setLowVlanId(VlanId value) {
        this._lowVlanId = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Config INSTANCE = new ConfigBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final VlanId _highVlanId;
        private final VlanId _lowVlanId;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._highVlanId = base.getHighVlanId();
            this._lowVlanId = base.getLowVlanId();
        }

        @Override
        public VlanId getHighVlanId() {
            return this._highVlanId;
        }

        @Override
        public VlanId getLowVlanId() {
            return this._lowVlanId;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

