/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.memory.top;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.memory.top.Memory;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.memory.top.memory.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.memory.top.memory.ConfigBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.memory.top.memory.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.memory.top.memory.StateBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class MemoryBuilder {
    private Config _config;
    private State _state;
    Map<Class<? extends Augmentation<Memory>>, Augmentation<Memory>> augmentation = Map.of();

    public MemoryBuilder() {
    }

    public MemoryBuilder(Memory base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Memory>>, Augmentation<Memory>>(aug);
        }
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public static @NonNull Memory empty() {
        return LazyEmpty.INSTANCE;
    }

    public Config getConfig() {
        return this._config;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Memory>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MemoryBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public MemoryBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public MemoryBuilder addAugmentation(Augmentation<Memory> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Memory>>, Augmentation<Memory>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public MemoryBuilder removeAugmentation(Class<? extends Augmentation<Memory>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Memory build() {
        return new MemoryImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Memory INSTANCE = new MemoryBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class MemoryImpl
    extends AbstractAugmentable<Memory>
    implements Memory {
        private final Config _config;
        private final State _state;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MemoryImpl(MemoryBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public State getState() {
            return this._state;
        }

        @Override
        public Config nonnullConfig() {
            return Objects.requireNonNullElse(this.getConfig(), ConfigBuilder.empty());
        }

        @Override
        public State nonnullState() {
            return Objects.requireNonNullElse(this.getState(), StateBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Memory.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Memory.bindingEquals(this, obj);
        }

        public String toString() {
            return Memory.bindingToString(this);
        }
    }
}

