/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.remote.servers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.LoggingSelectorsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.remote.servers.RemoteServer;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.remote.servers.RemoteServerKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.remote.servers.remote.server.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.remote.servers.remote.server.ConfigBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.remote.servers.remote.server.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.remote.servers.remote.server.StateBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.Selectors;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.SelectorsBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Host;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RemoteServerBuilder {
    private Config _config;
    private Host _host;
    private Selectors _selectors;
    private State _state;
    private RemoteServerKey key;
    Map<Class<? extends Augmentation<RemoteServer>>, Augmentation<RemoteServer>> augmentation = Map.of();

    public RemoteServerBuilder() {
    }

    public RemoteServerBuilder(LoggingSelectorsTop arg) {
        this._selectors = arg.getSelectors();
    }

    public RemoteServerBuilder(RemoteServer base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RemoteServer>>, Augmentation<RemoteServer>>(aug);
        }
        this.key = base.key();
        this._host = base.getHost();
        this._config = base.getConfig();
        this._selectors = base.getSelectors();
        this._state = base.getState();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LoggingSelectorsTop) {
            LoggingSelectorsTop castArg = (LoggingSelectorsTop)arg;
            this._selectors = castArg.getSelectors();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[LoggingSelectorsTop]");
    }

    public RemoteServerKey key() {
        return this.key;
    }

    public Config getConfig() {
        return this._config;
    }

    public Host getHost() {
        return this._host;
    }

    public Selectors getSelectors() {
        return this._selectors;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<RemoteServer>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public RemoteServerBuilder withKey(RemoteServerKey key) {
        this.key = key;
        return this;
    }

    public RemoteServerBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public RemoteServerBuilder setHost(Host value) {
        this._host = value;
        return this;
    }

    public RemoteServerBuilder setSelectors(Selectors value) {
        this._selectors = value;
        return this;
    }

    public RemoteServerBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public RemoteServerBuilder addAugmentation(Augmentation<RemoteServer> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RemoteServer>>, Augmentation<RemoteServer>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public RemoteServerBuilder removeAugmentation(Class<? extends Augmentation<RemoteServer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull RemoteServer build() {
        return new RemoteServerImpl(this);
    }

    private static final class RemoteServerImpl
    extends AbstractAugmentable<RemoteServer>
    implements RemoteServer {
        private final Config _config;
        private final Host _host;
        private final Selectors _selectors;
        private final State _state;
        private final RemoteServerKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        RemoteServerImpl(RemoteServerBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new RemoteServerKey(base.getHost());
            this._host = this.key.getHost();
            this._config = base.getConfig();
            this._selectors = base.getSelectors();
            this._state = base.getState();
        }

        @Override
        public RemoteServerKey key() {
            return this.key;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public Host getHost() {
            return this._host;
        }

        @Override
        public Selectors getSelectors() {
            return this._selectors;
        }

        @Override
        public State getState() {
            return this._state;
        }

        @Override
        public Config nonnullConfig() {
            return Objects.requireNonNullElse(this.getConfig(), ConfigBuilder.empty());
        }

        @Override
        public Selectors nonnullSelectors() {
            return Objects.requireNonNullElse(this.getSelectors(), SelectorsBuilder.empty());
        }

        @Override
        public State nonnullState() {
            return Objects.requireNonNullElse(this.getState(), StateBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = RemoteServer.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return RemoteServer.bindingEquals(this, obj);
        }

        public String toString() {
            return RemoteServer.bindingToString(this);
        }
    }
}

