/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.IntegratedCircuit;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.integrated.circuit.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.integrated.circuit.ConfigBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.integrated.circuit.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.integrated.circuit.StateBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class IntegratedCircuitBuilder {
    private Config _config;
    private State _state;
    Map<Class<? extends Augmentation<IntegratedCircuit>>, Augmentation<IntegratedCircuit>> augmentation = Map.of();

    public IntegratedCircuitBuilder() {
    }

    public IntegratedCircuitBuilder(IntegratedCircuit base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IntegratedCircuit>>, Augmentation<IntegratedCircuit>>(aug);
        }
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public static @NonNull IntegratedCircuit empty() {
        return LazyEmpty.INSTANCE;
    }

    public Config getConfig() {
        return this._config;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<IntegratedCircuit>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public IntegratedCircuitBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public IntegratedCircuitBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public IntegratedCircuitBuilder addAugmentation(Augmentation<IntegratedCircuit> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IntegratedCircuit>>, Augmentation<IntegratedCircuit>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public IntegratedCircuitBuilder removeAugmentation(Class<? extends Augmentation<IntegratedCircuit>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull IntegratedCircuit build() {
        return new IntegratedCircuitImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull IntegratedCircuit INSTANCE = new IntegratedCircuitBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class IntegratedCircuitImpl
    extends AbstractAugmentable<IntegratedCircuit>
    implements IntegratedCircuit {
        private final Config _config;
        private final State _state;
        private int hash = 0;
        private volatile boolean hashValid = false;

        IntegratedCircuitImpl(IntegratedCircuitBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public State getState() {
            return this._state;
        }

        @Override
        public Config nonnullConfig() {
            return Objects.requireNonNullElse(this.getConfig(), ConfigBuilder.empty());
        }

        @Override
        public State nonnullState() {
            return Objects.requireNonNullElse(this.getState(), StateBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = IntegratedCircuit.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return IntegratedCircuit.bindingEquals(this, obj);
        }

        public String toString() {
            return IntegratedCircuit.bindingToString(this);
        }
    }
}

