/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Backplane;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.backplane.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.backplane.ConfigBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.backplane.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.backplane.StateBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class BackplaneBuilder {
    private Config _config;
    private State _state;
    Map<Class<? extends Augmentation<Backplane>>, Augmentation<Backplane>> augmentation = Map.of();

    public BackplaneBuilder() {
    }

    public BackplaneBuilder(Backplane base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Backplane>>, Augmentation<Backplane>>(aug);
        }
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public static @NonNull Backplane empty() {
        return LazyEmpty.INSTANCE;
    }

    public Config getConfig() {
        return this._config;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Backplane>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public BackplaneBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public BackplaneBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public BackplaneBuilder addAugmentation(Augmentation<Backplane> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Backplane>>, Augmentation<Backplane>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public BackplaneBuilder removeAugmentation(Class<? extends Augmentation<Backplane>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Backplane build() {
        return new BackplaneImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Backplane INSTANCE = new BackplaneBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class BackplaneImpl
    extends AbstractAugmentable<Backplane>
    implements Backplane {
        private final Config _config;
        private final State _state;
        private int hash = 0;
        private volatile boolean hashValid = false;

        BackplaneImpl(BackplaneBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public State getState() {
            return this._state;
        }

        @Override
        public Config nonnullConfig() {
            return Objects.requireNonNullElse(this.getConfig(), ConfigBuilder.empty());
        }

        @Override
        public State nonnullState() {
            return Objects.requireNonNullElse(this.getState(), StateBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Backplane.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Backplane.bindingEquals(this, obj);
        }

        public String toString() {
            return Backplane.bindingToString(this);
        }
    }
}

