/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.subinterfaces.top.subinterfaces;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.subinterfaces.top.subinterfaces.Subinterface;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.subinterfaces.top.subinterfaces.SubinterfaceKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.subinterfaces.top.subinterfaces.subinterface.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.subinterfaces.top.subinterfaces.subinterface.ConfigBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.subinterfaces.top.subinterfaces.subinterface.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.subinterfaces.top.subinterfaces.subinterface.StateBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint32;

public class SubinterfaceBuilder {
    private Config _config;
    private Uint32 _index;
    private State _state;
    private SubinterfaceKey key;
    Map<Class<? extends Augmentation<Subinterface>>, Augmentation<Subinterface>> augmentation = Map.of();

    public SubinterfaceBuilder() {
    }

    public SubinterfaceBuilder(Subinterface base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Subinterface>>, Augmentation<Subinterface>>(aug);
        }
        this.key = base.key();
        this._index = base.getIndex();
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public SubinterfaceKey key() {
        return this.key;
    }

    public Config getConfig() {
        return this._config;
    }

    public Uint32 getIndex() {
        return this._index;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Subinterface>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public SubinterfaceBuilder withKey(SubinterfaceKey key) {
        this.key = key;
        return this;
    }

    public SubinterfaceBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public SubinterfaceBuilder setIndex(Uint32 value) {
        this._index = value;
        return this;
    }

    public SubinterfaceBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public SubinterfaceBuilder addAugmentation(Augmentation<Subinterface> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Subinterface>>, Augmentation<Subinterface>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public SubinterfaceBuilder removeAugmentation(Class<? extends Augmentation<Subinterface>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Subinterface build() {
        return new SubinterfaceImpl(this);
    }

    private static final class SubinterfaceImpl
    extends AbstractAugmentable<Subinterface>
    implements Subinterface {
        private final Config _config;
        private final Uint32 _index;
        private final State _state;
        private final SubinterfaceKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SubinterfaceImpl(SubinterfaceBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new SubinterfaceKey(base.getIndex());
            this._index = this.key.getIndex();
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public SubinterfaceKey key() {
            return this.key;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public Uint32 getIndex() {
            return this._index;
        }

        @Override
        public State getState() {
            return this._state;
        }

        @Override
        public Config nonnullConfig() {
            return Objects.requireNonNullElse(this.getConfig(), ConfigBuilder.empty());
        }

        @Override
        public State nonnullState() {
            return Objects.requireNonNullElse(this.getState(), StateBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Subinterface.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Subinterface.bindingEquals(this, obj);
        }

        public String toString() {
            return Subinterface.bindingToString(this);
        }
    }
}

