/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.users.user;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAuthenticationUserConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.users.user.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.CryptPasswordType;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder {
    private String _password;
    private CryptPasswordType _passwordHashed;
    private AaaAuthenticationUserConfig.Role _role;
    private String _sshKey;
    private String _username;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    public ConfigBuilder() {
    }

    public ConfigBuilder(AaaAuthenticationUserConfig arg) {
        this._username = arg.getUsername();
        this._password = arg.getPassword();
        this._passwordHashed = arg.getPasswordHashed();
        this._sshKey = arg.getSshKey();
        this._role = arg.getRole();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._password = base.getPassword();
        this._passwordHashed = base.getPasswordHashed();
        this._role = base.getRole();
        this._sshKey = base.getSshKey();
        this._username = base.getUsername();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaAuthenticationUserConfig) {
            AaaAuthenticationUserConfig castArg = (AaaAuthenticationUserConfig)arg;
            this._username = castArg.getUsername();
            this._password = castArg.getPassword();
            this._passwordHashed = castArg.getPasswordHashed();
            this._sshKey = castArg.getSshKey();
            this._role = castArg.getRole();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[AaaAuthenticationUserConfig]");
    }

    public static @NonNull Config empty() {
        return LazyEmpty.INSTANCE;
    }

    public String getPassword() {
        return this._password;
    }

    public CryptPasswordType getPasswordHashed() {
        return this._passwordHashed;
    }

    public AaaAuthenticationUserConfig.Role getRole() {
        return this._role;
    }

    public String getSshKey() {
        return this._sshKey;
    }

    public String getUsername() {
        return this._username;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setPassword(String value) {
        this._password = value;
        return this;
    }

    public ConfigBuilder setPasswordHashed(CryptPasswordType value) {
        this._passwordHashed = value;
        return this;
    }

    public ConfigBuilder setRole(AaaAuthenticationUserConfig.Role value) {
        this._role = value;
        return this;
    }

    public ConfigBuilder setSshKey(String value) {
        this._sshKey = value;
        return this;
    }

    public ConfigBuilder setUsername(String value) {
        this._username = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Config INSTANCE = new ConfigBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final String _password;
        private final CryptPasswordType _passwordHashed;
        private final AaaAuthenticationUserConfig.Role _role;
        private final String _sshKey;
        private final String _username;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._password = base.getPassword();
            this._passwordHashed = base.getPasswordHashed();
            this._role = base.getRole();
            this._sshKey = base.getSshKey();
            this._username = base.getUsername();
        }

        @Override
        public String getPassword() {
            return this._password;
        }

        @Override
        public CryptPasswordType getPasswordHashed() {
            return this._passwordHashed;
        }

        @Override
        public AaaAuthenticationUserConfig.Role getRole() {
            return this._role;
        }

        @Override
        public String getSshKey() {
            return this._sshKey;
        }

        @Override
        public String getUsername() {
            return this._username;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

