package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match._double.tagged.inner.range;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanLogicalDoubleTaggedInnerRangeConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match.DoubleTaggedInnerRange;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration for matching double-tagged packets against an inner range and 
 * outer exact VLAN identifiers.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * container config {
 *   uses vlan-logical-double-tagged-inner-range-config;
 * }
 * </pre>
 * <p>To create instances of this class use {@link ConfigBuilder}.
 * @see ConfigBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Config
    extends
    ChildOf<DoubleTaggedInnerRange>,
    Augmentable<Config>,
    VlanLogicalDoubleTaggedInnerRangeConfig
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("config");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match._double.tagged.inner.range.Config> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match._double.tagged.inner.range.Config.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match._double.tagged.inner.range.@NonNull Config obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getInnerHighVlanId());
        result = prime * result + Objects.hashCode(obj.getInnerLowVlanId());
        result = prime * result + Objects.hashCode(obj.getOuterVlanId());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match._double.tagged.inner.range.@NonNull Config thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match._double.tagged.inner.range.Config.class, obj);
        return other != null
            && Objects.equals(thisObj.getInnerHighVlanId(), other.getInnerHighVlanId())
            && Objects.equals(thisObj.getInnerLowVlanId(), other.getInnerLowVlanId())
            && Objects.equals(thisObj.getOuterVlanId(), other.getOuterVlanId())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match._double.tagged.inner.range.@NonNull Config obj) {
        final var helper = MoreObjects.toStringHelper("Config");
        CodeHelpers.appendValue(helper, "innerHighVlanId", obj.getInnerHighVlanId());
        CodeHelpers.appendValue(helper, "innerLowVlanId", obj.getInnerLowVlanId());
        CodeHelpers.appendValue(helper, "outerVlanId", obj.getOuterVlanId());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

