package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.ingress.mapping.top.IngressMapping;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Ingress VLAN stack behaviors for packets that arrive on this subinterface after 
 * their VLAN idenitifer(s) have been matched.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-logical-ingress-mapping-top {
 *   container ingress-mapping {
 *     container config {
 *       uses vlan-logical-ingress-mapping-config;
 *     }
 *     container state {
 *       config false;
 *       uses vlan-logical-ingress-mapping-config;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanLogicalIngressMappingTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-logical-ingress-mapping-top");

    @Override
    Class<? extends VlanLogicalIngressMappingTop> implementedInterface();
    
    /**
     * Return ingressMapping, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Ingress VLAN stack behaviors for packets that arrive on this subinterface after
     *         their VLAN idenitifer(s) have been matched.
     *     </code>
     * </pre>
     *
     * @return {@code IngressMapping} ingressMapping, or {@code null} if it is not present.
     *
     */
    IngressMapping getIngressMapping();
    
    /**
     * Return ingressMapping, or an empty instance if it is not present.
     *
     * @return {@code IngressMapping} ingressMapping, or an empty instance if it is not present.
     *
     */
    @NonNull IngressMapping nonnullIngressMapping();

}

