package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module defines configuration and state variables for VLANs, in addition to 
 * VLAN parameters associated with interfaces
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * module openconfig-vlan {
 *   yang-version 1;
 *   namespace "http://openconfig.net/yang/vlan";
 *   prefix oc-vlan;
 *   import openconfig-vlan-types {
 *     prefix oc-vlan-types;
 *   }
 *   import openconfig-interfaces {
 *     prefix oc-if;
 *   }
 *   import openconfig-if-ethernet {
 *     prefix oc-eth;
 *   }
 *   import openconfig-if-aggregate {
 *     prefix oc-lag;
 *   }
 *   import iana-if-type {
 *     prefix ianaift;
 *   }
 *   import openconfig-extensions {
 *     prefix oc-ext;
 *   }
 *   oc-ext:openconfig-version 3.2.0;
 *   revision 2019-04-16 {
 *   }
 *   revision 2019-01-31 {
 *   }
 *   revision 2018-11-21 {
 *   }
 *   revision 2018-06-05 {
 *   }
 *   revision 2018-02-14 {
 *   }
 *   revision 2017-07-14 {
 *   }
 *   revision 2016-05-26 {
 *   }
 *   oc-ext:regexp-posix;
 *   oc-ext:catalog-organization openconfig;
 *   oc-ext:origin openconfig;
 *   grouping vlan-config {
 *     leaf vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *     leaf name {
 *       type string;
 *     }
 *     leaf status {
 *       type enumeration {
 *         enum ACTIVE {
 *         }
 *         enum SUSPENDED {
 *         }
 *       }
 *       default ACTIVE;
 *     }
 *   }
 *   grouping vlan-state {
 *   }
 *   grouping vlan-tpid-config {
 *     leaf tpid {
 *       type identityref {
 *         base TPID_TYPES;
 *       }
 *       default oc-vlan-types:TPID_0X8100;
 *     }
 *   }
 *   grouping vlan-tpid-state {
 *   }
 *   grouping vlan-members-state {
 *     container members {
 *       list member {
 *         config false;
 *         uses oc-if:base-interface-ref-state;
 *       }
 *     }
 *   }
 *   grouping vlan-switched-config {
 *     leaf interface-mode {
 *       type oc-vlan-types:vlan-mode-type;
 *     }
 *     leaf native-vlan {
 *       when "../interface-mode = 'TRUNK'" {
 *       }
 *       type oc-vlan-types:vlan-id;
 *     }
 *     leaf access-vlan {
 *       when "../interface-mode = 'ACCESS'" {
 *       }
 *       type oc-vlan-types:vlan-id;
 *     }
 *     leaf-list trunk-vlans {
 *       when "../interface-mode = 'TRUNK'" {
 *       }
 *       type union {
 *         type oc-vlan-types:vlan-id;
 *         type oc-vlan-types:vlan-range;
 *       }
 *     }
 *   }
 *   grouping vlan-switched-state {
 *   }
 *   grouping vlan-switched-top {
 *     container switched-vlan {
 *       container config {
 *         uses vlan-switched-config;
 *       }
 *       container state {
 *         config false;
 *         uses vlan-switched-config;
 *         uses vlan-switched-state;
 *       }
 *     }
 *   }
 *   grouping vlan-logical-config {
 *     leaf vlan-id {
 *       type union {
 *         type oc-vlan-types:vlan-id;
 *         type oc-vlan-types:qinq-id;
 *       }
 *       status deprecated;
 *     }
 *   }
 *   grouping vlan-logical-state {
 *   }
 *   grouping vlan-logical-single-tagged-config {
 *     leaf vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *   }
 *   grouping vlan-logical-single-tagged-list-config {
 *     leaf-list vlan-ids {
 *       type oc-vlan-types:vlan-id;
 *     }
 *   }
 *   grouping vlan-logical-single-tagged-range-config {
 *     leaf low-vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *     leaf high-vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *   }
 *   grouping vlan-logical-double-tagged-config {
 *     leaf inner-vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *     leaf outer-vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *   }
 *   grouping vlan-logical-double-tagged-inner-list-config {
 *     leaf-list inner-vlan-ids {
 *       type oc-vlan-types:vlan-id;
 *     }
 *     leaf outer-vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *   }
 *   grouping vlan-logical-double-tagged-outer-list-config {
 *     leaf inner-vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *     leaf-list outer-vlan-ids {
 *       type oc-vlan-types:vlan-id;
 *     }
 *   }
 *   grouping vlan-logical-double-tagged-inner-range-config {
 *     leaf inner-low-vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *     leaf inner-high-vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *     leaf-list outer-vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *   }
 *   grouping vlan-logical-double-tagged-outer-range-config {
 *     leaf inner-vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *     leaf outer-low-vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *     leaf outer-high-vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *   }
 *   grouping vlan-logical-double-tagged-inner-outer-range-config {
 *     leaf inner-low-vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *     leaf inner-high-vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *     leaf outer-low-vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *     leaf outer-high-vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *   }
 *   grouping vlan-logical-match-top {
 *     container match {
 *       container single-tagged {
 *         container config {
 *           uses vlan-logical-single-tagged-config;
 *         }
 *         container state {
 *           config false;
 *           uses vlan-logical-single-tagged-config;
 *         }
 *       }
 *       container single-tagged-list {
 *         container config {
 *           uses vlan-logical-single-tagged-list-config;
 *         }
 *         container state {
 *           config false;
 *           uses vlan-logical-single-tagged-list-config;
 *         }
 *       }
 *       container single-tagged-range {
 *         container config {
 *           uses vlan-logical-single-tagged-range-config;
 *         }
 *         container state {
 *           config false;
 *           uses vlan-logical-single-tagged-range-config;
 *         }
 *       }
 *       container double-tagged {
 *         container config {
 *           uses vlan-logical-double-tagged-config;
 *         }
 *         container state {
 *           config false;
 *           uses vlan-logical-double-tagged-config;
 *         }
 *       }
 *       container double-tagged-inner-list {
 *         container config {
 *           uses vlan-logical-double-tagged-inner-list-config;
 *         }
 *         container state {
 *           config false;
 *           uses vlan-logical-double-tagged-inner-list-config;
 *         }
 *       }
 *       container double-tagged-outer-list {
 *         container config {
 *           uses vlan-logical-double-tagged-outer-list-config;
 *         }
 *         container state {
 *           config false;
 *           uses vlan-logical-double-tagged-outer-list-config;
 *         }
 *       }
 *       container double-tagged-inner-range {
 *         container config {
 *           uses vlan-logical-double-tagged-inner-range-config;
 *         }
 *         container state {
 *           config false;
 *           uses vlan-logical-double-tagged-inner-range-config;
 *         }
 *       }
 *       container double-tagged-outer-range {
 *         container config {
 *           uses vlan-logical-double-tagged-outer-range-config;
 *         }
 *         container state {
 *           config false;
 *           uses vlan-logical-double-tagged-outer-range-config;
 *         }
 *       }
 *       container double-tagged-inner-outer-range {
 *         container config {
 *           uses vlan-logical-double-tagged-inner-outer-range-config;
 *         }
 *         container state {
 *           config false;
 *           uses vlan-logical-double-tagged-inner-outer-range-config;
 *         }
 *       }
 *     }
 *   }
 *   grouping vlan-logical-ingress-mapping-config {
 *     leaf vlan-stack-action {
 *       type oc-vlan-types:vlan-stack-action;
 *     }
 *     leaf vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *     leaf tpid {
 *       type identityref {
 *         base TPID_TYPES;
 *       }
 *     }
 *   }
 *   grouping vlan-logical-ingress-mapping-top {
 *     container ingress-mapping {
 *       container config {
 *         uses vlan-logical-ingress-mapping-config;
 *       }
 *       container state {
 *         config false;
 *         uses vlan-logical-ingress-mapping-config;
 *       }
 *     }
 *   }
 *   grouping vlan-logical-egress-mapping-config {
 *     leaf vlan-stack-action {
 *       type oc-vlan-types:vlan-stack-action;
 *     }
 *     leaf vlan-id {
 *       type oc-vlan-types:vlan-id;
 *     }
 *     leaf tpid {
 *       type identityref {
 *         base TPID_TYPES;
 *       }
 *     }
 *   }
 *   grouping vlan-logical-egress-mapping-top {
 *     container egress-mapping {
 *       container config {
 *         uses vlan-logical-egress-mapping-config;
 *       }
 *       container state {
 *         config false;
 *         uses vlan-logical-egress-mapping-config;
 *       }
 *     }
 *   }
 *   grouping vlan-top {
 *     container vlans {
 *       list vlan {
 *         key vlan-id;
 *         leaf vlan-id {
 *           type leafref {
 *             path ../config/vlan-id;
 *           }
 *         }
 *         container config {
 *           uses vlan-config;
 *         }
 *         container state {
 *           config false;
 *           uses vlan-config;
 *           uses vlan-state;
 *         }
 *         uses vlan-members-state;
 *       }
 *     }
 *   }
 *   grouping vlan-logical-top {
 *     container vlan {
 *       container config {
 *         uses vlan-logical-config;
 *       }
 *       container state {
 *         config false;
 *         uses vlan-logical-config;
 *         uses vlan-logical-state;
 *       }
 *       uses vlan-logical-match-top;
 *       uses vlan-logical-ingress-mapping-top;
 *       uses vlan-logical-egress-mapping-top;
 *     }
 *   }
 *   grouping vlan-routed-config {
 *     leaf vlan {
 *       type union {
 *         type uint16;
 *         type string;
 *       }
 *     }
 *   }
 *   grouping vlan-routed-state {
 *   }
 *   grouping vlan-routed-top {
 *     container routed-vlan {
 *       container config {
 *         uses vlan-routed-config;
 *       }
 *       container state {
 *         config false;
 *         uses vlan-routed-config;
 *         uses vlan-routed-state;
 *       }
 *     }
 *   }
 *   augment /oc-if:interfaces/oc-if:interface/oc-if:subinterfaces/oc-if:subinterface {
 *     uses vlan-logical-top;
 *   }
 *   augment /oc-if:interfaces/oc-if:interface/oc-if:config {
 *     uses vlan-tpid-config;
 *   }
 *   augment /oc-if:interfaces/oc-if:interface/oc-if:state {
 *     uses vlan-tpid-config;
 *     uses vlan-tpid-state;
 *   }
 *   augment /oc-if:interfaces/oc-if:interface/oc-eth:ethernet {
 *     uses vlan-switched-top;
 *   }
 *   augment /oc-if:interfaces/oc-if:interface/oc-lag:aggregation {
 *     uses vlan-switched-top;
 *   }
 *   augment /oc-if:interfaces/oc-if:interface {
 *     uses vlan-routed-top {
 *       when "current()/oc-if:config/oc-if:type = 'ianaift:l3ipvlan'" {
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenconfigVlanData
    extends
    DataRoot
{





}

