package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemGlobalConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemGlobalState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.System;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Global operational state data for the system
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * container state {
 *   config false;
 *   uses system-global-config;
 *   uses system-global-state;
 * }
 * </pre>
 * <p>To create instances of this class use {@link StateBuilder}.
 * @see StateBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface State
    extends
    ChildOf<System>,
    Augmentable<State>,
    SystemGlobalConfig,
    SystemGlobalState
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("state");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system.State> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system.State.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system.@NonNull State obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getBootTime());
        result = prime * result + Objects.hashCode(obj.getCurrentDatetime());
        result = prime * result + Objects.hashCode(obj.getDomainName());
        result = prime * result + Objects.hashCode(obj.getHostname());
        result = prime * result + Objects.hashCode(obj.getLoginBanner());
        result = prime * result + Objects.hashCode(obj.getMotdBanner());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system.@NonNull State thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system.State.class, obj);
        return other != null
            && Objects.equals(thisObj.getBootTime(), other.getBootTime())
            && Objects.equals(thisObj.getCurrentDatetime(), other.getCurrentDatetime())
            && Objects.equals(thisObj.getDomainName(), other.getDomainName())
            && Objects.equals(thisObj.getHostname(), other.getHostname())
            && Objects.equals(thisObj.getLoginBanner(), other.getLoginBanner())
            && Objects.equals(thisObj.getMotdBanner(), other.getMotdBanner())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system.@NonNull State obj) {
        final var helper = MoreObjects.toStringHelper("State");
        CodeHelpers.appendValue(helper, "bootTime", obj.getBootTime());
        CodeHelpers.appendValue(helper, "currentDatetime", obj.getCurrentDatetime());
        CodeHelpers.appendValue(helper, "domainName", obj.getDomainName());
        CodeHelpers.appendValue(helper, "hostname", obj.getHostname());
        CodeHelpers.appendValue(helper, "loginBanner", obj.getLoginBanner());
        CodeHelpers.appendValue(helper, "motdBanner", obj.getMotdBanner());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

