package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.AlarmsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.LicenseTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.MessagesTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.LoggingTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.ProcmonProcessesTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemClockTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemMemoryTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemSshServerTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemTelnetServerTop;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container for system-related configuration and operational state data
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * container system {
 *   container config {
 *     uses system-global-config;
 *   }
 *   container state {
 *     config false;
 *     uses system-global-config;
 *     uses system-global-state;
 *   }
 *   uses system-clock-top;
 *   uses system-dns-top;
 *   uses system-ntp-top;
 *   uses oc-sys-term:system-ssh-server-top;
 *   uses oc-sys-term:system-telnet-server-top;
 *   uses oc-log:logging-top;
 *   uses oc-aaa:aaa-top;
 *   uses system-memory-top;
 *   uses system-cpu-top;
 *   uses oc-proc:procmon-processes-top;
 *   uses oc-alarms:alarms-top;
 *   uses oc-messages:messages-top;
 *   uses oc-license:license-top;
 * }
 * </pre>
 * <p>To create instances of this class use {@link SystemBuilder}.
 * @see SystemBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface System
    extends
    ChildOf<SystemTop>,
    Augmentable<System>,
    SystemClockTop,
    SystemDnsTop,
    SystemNtpTop,
    SystemSshServerTop,
    SystemTelnetServerTop,
    LoggingTop,
    AaaTop,
    SystemMemoryTop,
    SystemCpuTop,
    ProcmonProcessesTop,
    AlarmsTop,
    MessagesTop,
    LicenseTop
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.System> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.System.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.@NonNull System obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAaa());
        result = prime * result + Objects.hashCode(obj.getAlarms());
        result = prime * result + Objects.hashCode(obj.getClock());
        result = prime * result + Objects.hashCode(obj.getConfig());
        result = prime * result + Objects.hashCode(obj.getCpus());
        result = prime * result + Objects.hashCode(obj.getDns());
        result = prime * result + Objects.hashCode(obj.getLicense());
        result = prime * result + Objects.hashCode(obj.getLogging());
        result = prime * result + Objects.hashCode(obj.getMemory());
        result = prime * result + Objects.hashCode(obj.getMessages());
        result = prime * result + Objects.hashCode(obj.getNtp());
        result = prime * result + Objects.hashCode(obj.getProcesses());
        result = prime * result + Objects.hashCode(obj.getSshServer());
        result = prime * result + Objects.hashCode(obj.getState());
        result = prime * result + Objects.hashCode(obj.getTelnetServer());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.@NonNull System thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.System.class, obj);
        return other != null
            && Objects.equals(thisObj.getAaa(), other.getAaa())
            && Objects.equals(thisObj.getAlarms(), other.getAlarms())
            && Objects.equals(thisObj.getClock(), other.getClock())
            && Objects.equals(thisObj.getConfig(), other.getConfig())
            && Objects.equals(thisObj.getCpus(), other.getCpus())
            && Objects.equals(thisObj.getDns(), other.getDns())
            && Objects.equals(thisObj.getLicense(), other.getLicense())
            && Objects.equals(thisObj.getLogging(), other.getLogging())
            && Objects.equals(thisObj.getMemory(), other.getMemory())
            && Objects.equals(thisObj.getMessages(), other.getMessages())
            && Objects.equals(thisObj.getNtp(), other.getNtp())
            && Objects.equals(thisObj.getProcesses(), other.getProcesses())
            && Objects.equals(thisObj.getSshServer(), other.getSshServer())
            && Objects.equals(thisObj.getState(), other.getState())
            && Objects.equals(thisObj.getTelnetServer(), other.getTelnetServer())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.@NonNull System obj) {
        final var helper = MoreObjects.toStringHelper("System");
        CodeHelpers.appendValue(helper, "aaa", obj.getAaa());
        CodeHelpers.appendValue(helper, "alarms", obj.getAlarms());
        CodeHelpers.appendValue(helper, "clock", obj.getClock());
        CodeHelpers.appendValue(helper, "config", obj.getConfig());
        CodeHelpers.appendValue(helper, "cpus", obj.getCpus());
        CodeHelpers.appendValue(helper, "dns", obj.getDns());
        CodeHelpers.appendValue(helper, "license", obj.getLicense());
        CodeHelpers.appendValue(helper, "logging", obj.getLogging());
        CodeHelpers.appendValue(helper, "memory", obj.getMemory());
        CodeHelpers.appendValue(helper, "messages", obj.getMessages());
        CodeHelpers.appendValue(helper, "ntp", obj.getNtp());
        CodeHelpers.appendValue(helper, "processes", obj.getProcesses());
        CodeHelpers.appendValue(helper, "sshServer", obj.getSshServer());
        CodeHelpers.appendValue(helper, "state", obj.getState());
        CodeHelpers.appendValue(helper, "telnetServer", obj.getTelnetServer());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return config, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Global configuration data for the system
     *     </code>
     * </pre>
     *
     * @return {@code Config} config, or {@code null} if it is not present.
     *
     */
    Config getConfig();
    
    /**
     * Return config, or an empty instance if it is not present.
     *
     * @return {@code Config} config, or an empty instance if it is not present.
     *
     */
    @NonNull Config nonnullConfig();
    
    /**
     * Return state, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Global operational state data for the system
     *     </code>
     * </pre>
     *
     * @return {@code State} state, or {@code null} if it is not present.
     *
     */
    State getState();
    
    /**
     * Return state, or an empty instance if it is not present.
     *
     * @return {@code State} state, or an empty instance if it is not present.
     *
     */
    @NonNull State nonnullState();

}

