package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpAuthKeysTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpServerTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.NtpKeys;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.Servers;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top.ntp.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top.ntp.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Ntp} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Ntp createNtp(int fooXyzzy, int barBaz) {
 *         return new NtpBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Ntp, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Ntp
 *
 */
@Generated("mdsal-binding-generator")
public class NtpBuilder {

    private Config _config;
    private NtpKeys _ntpKeys;
    private Servers _servers;
    private State _state;


    Map<Class<? extends Augmentation<Ntp>>, Augmentation<Ntp>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public NtpBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link SystemNtpAuthKeysTop}.
     *
     * @param arg SystemNtpAuthKeysTop from which the builder should be initialized
     */
    public NtpBuilder(SystemNtpAuthKeysTop arg) {
        this._ntpKeys = arg.getNtpKeys();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link SystemNtpServerTop}.
     *
     * @param arg SystemNtpServerTop from which the builder should be initialized
     */
    public NtpBuilder(SystemNtpServerTop arg) {
        this._servers = arg.getServers();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Ntp}.
     *
     * @param base Ntp from which the builder should be initialized
     */
    public NtpBuilder(Ntp base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._config = base.getConfig();
        this._ntpKeys = base.getNtpKeys();
        this._servers = base.getServers();
        this._state = base.getState();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link SystemNtpAuthKeysTop}</li>
     *   <li>{@link SystemNtpServerTop}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemNtpAuthKeysTop castArg) {
            this._ntpKeys = castArg.getNtpKeys();
            isValidArg = true;
        }
        if (arg instanceof SystemNtpServerTop castArg) {
            this._servers = castArg.getServers();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SystemNtpAuthKeysTop, SystemNtpServerTop]");
    }

    private static final class LazyEmpty {
        static final @NonNull Ntp INSTANCE = new NtpBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of Ntp.
     *
     * @return An empty {@link Ntp}
     */
    public static @NonNull Ntp empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link Ntp#getConfig()}.
     *
     * @return current value
     */
    public Config getConfig() {
        return _config;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Ntp#getNtpKeys()}.
     *
     * @return current value
     */
    public NtpKeys getNtpKeys() {
        return _ntpKeys;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Ntp#getServers()}.
     *
     * @return current value
     */
    public Servers getServers() {
        return _servers;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Ntp#getState()}.
     *
     * @return current value
     */
    public State getState() {
        return _state;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Ntp>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Ntp#getConfig()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NtpBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Ntp#getNtpKeys()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NtpBuilder setNtpKeys(final NtpKeys value) {
        this._ntpKeys = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Ntp#getServers()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NtpBuilder setServers(final Servers value) {
        this._servers = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Ntp#getState()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public NtpBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NtpBuilder addAugmentation(Augmentation<Ntp> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NtpBuilder removeAugmentation(Class<? extends Augmentation<Ntp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Ntp} instance.
     *
     * @return A new {@link Ntp} instance.
     */
    public @NonNull Ntp build() {
        return new NtpImpl(this);
    }

    private static final class NtpImpl
        extends AbstractAugmentable<Ntp>
        implements Ntp {
    
        private final Config _config;
        private final NtpKeys _ntpKeys;
        private final Servers _servers;
        private final State _state;
    
        NtpImpl(NtpBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._ntpKeys = base.getNtpKeys();
            this._servers = base.getServers();
            this._state = base.getState();
        }
    
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public NtpKeys getNtpKeys() {
            return _ntpKeys;
        }
        
        @Override
        public Servers getServers() {
            return _servers;
        }
        
        @Override
        public State getState() {
            return _state;
        }
    
        @Override
        public Config nonnullConfig() {
            return Objects.requireNonNullElse(getConfig(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top.ntp.ConfigBuilder.empty());
        }
        
        @Override
        public NtpKeys nonnullNtpKeys() {
            return Objects.requireNonNullElse(getNtpKeys(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.NtpKeysBuilder.empty());
        }
        
        @Override
        public Servers nonnullServers() {
            return Objects.requireNonNullElse(getServers(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.ServersBuilder.empty());
        }
        
        @Override
        public State nonnullState() {
            return Objects.requireNonNullElse(getState(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top.ntp.StateBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Ntp.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Ntp.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Ntp.bindingToString(this);
        }
    }
}
