package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Host;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link Server} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Server createServer(int fooXyzzy, int barBaz) {
 *         return new ServerBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Server, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Server
 *
 */
@Generated("mdsal-binding-generator")
public class ServerBuilder {

    private Host _address;
    private Config _config;
    private State _state;
    private ServerKey key;


    Map<Class<? extends Augmentation<Server>>, Augmentation<Server>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ServerBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link Server}.
     *
     * @param base Server from which the builder should be initialized
     */
    public ServerBuilder(Server base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._address = base.getAddress();
        this._config = base.getConfig();
        this._state = base.getState();
    }



    /**
     * Return current value associated with the property corresponding to {@link Server#key()}.
     *
     * @return current value
     */
    public ServerKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Server#getAddress()}.
     *
     * @return current value
     */
    public Host getAddress() {
        return _address;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Server#getConfig()}.
     *
     * @return current value
     */
    public Config getConfig() {
        return _config;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Server#getState()}.
     *
     * @return current value
     */
    public State getState() {
        return _state;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Server>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Server#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public ServerBuilder withKey(final ServerKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Server#getAddress()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ServerBuilder setAddress(final Host value) {
        this._address = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Server#getConfig()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ServerBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Server#getState()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ServerBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ServerBuilder addAugmentation(Augmentation<Server> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ServerBuilder removeAugmentation(Class<? extends Augmentation<Server>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Server} instance.
     *
     * @return A new {@link Server} instance.
     */
    public @NonNull Server build() {
        return new ServerImpl(this);
    }

    private static final class ServerImpl
        extends AbstractAugmentable<Server>
        implements Server {
    
        private final Host _address;
        private final Config _config;
        private final State _state;
        private final ServerKey key;
    
        ServerImpl(ServerBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new ServerKey(base.getAddress());
            }
            this._address = key.getAddress();
            this._config = base.getConfig();
            this._state = base.getState();
        }
    
        @Override
        public ServerKey key() {
            return key;
        }
        
        @Override
        public Host getAddress() {
            return _address;
        }
        
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public State getState() {
            return _state;
        }
    
        
        @Override
        public Config nonnullConfig() {
            return Objects.requireNonNullElse(getConfig(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.ConfigBuilder.empty());
        }
        
        @Override
        public State nonnullState() {
            return Objects.requireNonNullElse(getState(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.StateBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Server.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Server.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Server.bindingToString(this);
        }
    }
}
