package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus.cpu;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuState.Index;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.HardwareInterrupt;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Idle;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Kernel;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Nice;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.SoftwareInterrupt;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Total;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.User;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Wait;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private HardwareInterrupt _hardwareInterrupt;
    private Idle _idle;
    private Index _index;
    private Kernel _kernel;
    private Nice _nice;
    private SoftwareInterrupt _softwareInterrupt;
    private Total _total;
    private User _user;
    private Wait _wait;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public StateBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link SystemCpuState}.
     *
     * @param arg SystemCpuState from which the builder should be initialized
     */
    public StateBuilder(SystemCpuState arg) {
        this._index = arg.getIndex();
        this._total = arg.getTotal();
        this._user = arg.getUser();
        this._kernel = arg.getKernel();
        this._nice = arg.getNice();
        this._idle = arg.getIdle();
        this._wait = arg.getWait();
        this._hardwareInterrupt = arg.getHardwareInterrupt();
        this._softwareInterrupt = arg.getSoftwareInterrupt();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link State}.
     *
     * @param base State from which the builder should be initialized
     */
    public StateBuilder(State base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._hardwareInterrupt = base.getHardwareInterrupt();
        this._idle = base.getIdle();
        this._index = base.getIndex();
        this._kernel = base.getKernel();
        this._nice = base.getNice();
        this._softwareInterrupt = base.getSoftwareInterrupt();
        this._total = base.getTotal();
        this._user = base.getUser();
        this._wait = base.getWait();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link SystemCpuState}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemCpuState castArg) {
            this._index = castArg.getIndex();
            this._total = castArg.getTotal();
            this._user = castArg.getUser();
            this._kernel = castArg.getKernel();
            this._nice = castArg.getNice();
            this._idle = castArg.getIdle();
            this._wait = castArg.getWait();
            this._hardwareInterrupt = castArg.getHardwareInterrupt();
            this._softwareInterrupt = castArg.getSoftwareInterrupt();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SystemCpuState]");
    }

    private static final class LazyEmpty {
        static final @NonNull State INSTANCE = new StateBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of State.
     *
     * @return An empty {@link State}
     */
    public static @NonNull State empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link State#getHardwareInterrupt()}.
     *
     * @return current value
     */
    public HardwareInterrupt getHardwareInterrupt() {
        return _hardwareInterrupt;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getIdle()}.
     *
     * @return current value
     */
    public Idle getIdle() {
        return _idle;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getIndex()}.
     *
     * @return current value
     */
    public Index getIndex() {
        return _index;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getKernel()}.
     *
     * @return current value
     */
    public Kernel getKernel() {
        return _kernel;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getNice()}.
     *
     * @return current value
     */
    public Nice getNice() {
        return _nice;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getSoftwareInterrupt()}.
     *
     * @return current value
     */
    public SoftwareInterrupt getSoftwareInterrupt() {
        return _softwareInterrupt;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getTotal()}.
     *
     * @return current value
     */
    public Total getTotal() {
        return _total;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getUser()}.
     *
     * @return current value
     */
    public User getUser() {
        return _user;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getWait()}.
     *
     * @return current value
     */
    public Wait getWait() {
        return _wait;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link State#getHardwareInterrupt()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setHardwareInterrupt(final HardwareInterrupt value) {
        this._hardwareInterrupt = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getIdle()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setIdle(final Idle value) {
        this._idle = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getIndex()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setIndex(final Index value) {
        this._index = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getKernel()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setKernel(final Kernel value) {
        this._kernel = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getNice()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setNice(final Nice value) {
        this._nice = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getSoftwareInterrupt()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setSoftwareInterrupt(final SoftwareInterrupt value) {
        this._softwareInterrupt = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getTotal()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setTotal(final Total value) {
        this._total = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getUser()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setUser(final User value) {
        this._user = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getWait()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setWait(final Wait value) {
        this._wait = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final HardwareInterrupt _hardwareInterrupt;
        private final Idle _idle;
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuState.Index _index;
        private final Kernel _kernel;
        private final Nice _nice;
        private final SoftwareInterrupt _softwareInterrupt;
        private final Total _total;
        private final User _user;
        private final Wait _wait;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._hardwareInterrupt = base.getHardwareInterrupt();
            this._idle = base.getIdle();
            this._index = base.getIndex();
            this._kernel = base.getKernel();
            this._nice = base.getNice();
            this._softwareInterrupt = base.getSoftwareInterrupt();
            this._total = base.getTotal();
            this._user = base.getUser();
            this._wait = base.getWait();
        }
    
        @Override
        public HardwareInterrupt getHardwareInterrupt() {
            return _hardwareInterrupt;
        }
        
        @Override
        public Idle getIdle() {
            return _idle;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuState.Index getIndex() {
            return _index;
        }
        
        @Override
        public Kernel getKernel() {
            return _kernel;
        }
        
        @Override
        public Nice getNice() {
            return _nice;
        }
        
        @Override
        public SoftwareInterrupt getSoftwareInterrupt() {
            return _softwareInterrupt;
        }
        
        @Override
        public Total getTotal() {
            return _total;
        }
        
        @Override
        public User getUser() {
            return _user;
        }
        
        @Override
        public Wait getWait() {
            return _wait;
        }
    
        @Override
        public HardwareInterrupt nonnullHardwareInterrupt() {
            return Objects.requireNonNullElse(getHardwareInterrupt(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.HardwareInterruptBuilder.empty());
        }
        
        @Override
        public Idle nonnullIdle() {
            return Objects.requireNonNullElse(getIdle(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.IdleBuilder.empty());
        }
        
        
        @Override
        public Kernel nonnullKernel() {
            return Objects.requireNonNullElse(getKernel(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.KernelBuilder.empty());
        }
        
        @Override
        public Nice nonnullNice() {
            return Objects.requireNonNullElse(getNice(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.NiceBuilder.empty());
        }
        
        @Override
        public SoftwareInterrupt nonnullSoftwareInterrupt() {
            return Objects.requireNonNullElse(getSoftwareInterrupt(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.SoftwareInterruptBuilder.empty());
        }
        
        @Override
        public Total nonnullTotal() {
            return Objects.requireNonNullElse(getTotal(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.TotalBuilder.empty());
        }
        
        @Override
        public User nonnullUser() {
            return Objects.requireNonNullElse(getUser(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.UserBuilder.empty());
        }
        
        @Override
        public Wait nonnullWait() {
            return Objects.requireNonNullElse(getWait(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.WaitBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
