package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.Servers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for the list of DNS resolvers.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-dns-servers-top {
 *   container servers {
 *     list server {
 *       key address;
 *       ordered-by user;
 *       leaf address {
 *         type leafref {
 *           path ../config/address;
 *         }
 *       }
 *       container config {
 *         uses system-dns-servers-config;
 *       }
 *       container state {
 *         config false;
 *         uses system-dns-servers-config;
 *         uses system-dns-servers-state;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemDnsServersTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-dns-servers-top");

    @Override
    Class<? extends SystemDnsServersTop> implementedInterface();
    
    /**
     * Return servers, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container for DNS resolver list
     *     </code>
     * </pre>
     *
     * @return {@code Servers} servers, or {@code null} if it is not present.
     *
     */
    Servers getServers();
    
    /**
     * Return servers, or an empty instance if it is not present.
     *
     * @return {@code Servers} servers, or an empty instance if it is not present.
     *
     */
    @NonNull Servers nonnullServers();

}

