package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for DNS resolvers
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-dns-servers-config {
 *   leaf address {
 *     type oc-inet:ip-address;
 *   }
 *   leaf port {
 *     type oc-inet:port-number;
 *     default 53;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemDnsServersConfig
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-dns-servers-config");

    @Override
    Class<? extends SystemDnsServersConfig> implementedInterface();
    
    /**
     * Return address, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The address of the DNS server, can be either IPv4 or IPv6.
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} address, or {@code null} if it is not present.
     *
     */
    IpAddress getAddress();
    
    /**
     * Return address, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The address of the DNS server, can be either IPv4 or IPv6.
     *     </code>
     * </pre>
     *
     * @return {@code IpAddress} address, guaranteed to be non-null.
     * @throws NoSuchElementException if address is not present
     *
     */
    default @NonNull IpAddress requireAddress() {
        return CodeHelpers.require(getAddress(), "address");
    }
    
    /**
     * Return port, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The port number of the DNS server.
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} port, or {@code null} if it is not present.
     *
     */
    PortNumber getPort();
    
    /**
     * Return port, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The port number of the DNS server.
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} port, guaranteed to be non-null.
     * @throws NoSuchElementException if port is not present
     *
     */
    default @NonNull PortNumber requirePort() {
        return CodeHelpers.require(getPort(), "port");
    }

}

