package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for system-wide clock configuration
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-clock-config {
 *   leaf timezone-name {
 *     type timezone-name-type;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemClockConfig
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-clock-config");

    @Override
    Class<? extends SystemClockConfig> implementedInterface();
    
    /**
     * Return timezoneName, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The TZ database name to use for the system, such as 'Europe/Stockholm'.
     *     </code>
     * </pre>
     *
     * @return {@code TimezoneNameType} timezoneName, or {@code null} if it is not present.
     *
     */
    TimezoneNameType getTimezoneName();
    
    /**
     * Return timezoneName, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The TZ database name to use for the system, such as 'Europe/Stockholm'.
     *     </code>
     * </pre>
     *
     * @return {@code TimezoneNameType} timezoneName, guaranteed to be non-null.
     * @throws NoSuchElementException if timezoneName is not present
     *
     */
    default @NonNull TimezoneNameType requireTimezoneName() {
        return CodeHelpers.require(getTimezoneName(), "timezonename");
    }

}

