package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Percentage;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Timeticks64;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.Counter64;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * Attributes state definitions for a process
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-procmon</b>
 * <pre>
 * grouping procmon-process-attributes-state {
 *   leaf pid {
 *     type uint64;
 *   }
 *   leaf name {
 *     type string;
 *   }
 *   leaf-list args {
 *     type string;
 *   }
 *   leaf start-time {
 *     type oc-types:timeticks64;
 *   }
 *   leaf cpu-usage-user {
 *     type oc-yang:counter64;
 *     units nanoseconds;
 *   }
 *   leaf cpu-usage-system {
 *     type oc-yang:counter64;
 *     units nanoseconds;
 *   }
 *   leaf cpu-utilization {
 *     type oc-types:percentage;
 *   }
 *   leaf memory-usage {
 *     type uint64;
 *     units bytes;
 *   }
 *   leaf memory-utilization {
 *     type oc-types:percentage;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface ProcmonProcessAttributesState
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("procmon-process-attributes-state");

    @Override
    Class<? extends ProcmonProcessAttributesState> implementedInterface();
    
    /**
     * Return pid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The process pid
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} pid, or {@code null} if it is not present.
     *
     */
    Uint64 getPid();
    
    /**
     * Return pid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The process pid
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} pid, guaranteed to be non-null.
     * @throws NoSuchElementException if pid is not present
     *
     */
    default @NonNull Uint64 requirePid() {
        return CodeHelpers.require(getPid(), "pid");
    }
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The process name
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The process name
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return args, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Current process command line arguments. Arguments with a parameter (e.g.,
     *         --option 10 or -option=10) should be represented as a single element of the list
     *         with the argument name and parameter together. Flag arguments, i.e., those
     *         without a parameter should also be in their own list element.
     *     </code>
     * </pre>
     *
     * @return {@code Set<String>} args, or {@code null} if it is not present.
     *
     */
    @Nullable Set<String> getArgs();
    
    /**
     * Return args, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Current process command line arguments. Arguments with a parameter (e.g.,
     *         --option 10 or -option=10) should be represented as a single element of the list
     *         with the argument name and parameter together. Flag arguments, i.e., those
     *         without a parameter should also be in their own list element.
     *     </code>
     * </pre>
     *
     * @return {@code Set<String>} args, guaranteed to be non-null.
     * @throws NoSuchElementException if args is not present
     *
     */
    default @NonNull Set<String> requireArgs() {
        return CodeHelpers.require(getArgs(), "args");
    }
    
    /**
     * Return startTime, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The time at which this process started, relative to the UNIX epoch. The system
     *         must be synchronized such that the start-time can be reported accurately,
     *         otherwise it should not be reported.
     *     </code>
     * </pre>
     *
     * @return {@code Timeticks64} startTime, or {@code null} if it is not present.
     *
     */
    Timeticks64 getStartTime();
    
    /**
     * Return startTime, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The time at which this process started, relative to the UNIX epoch. The system
     *         must be synchronized such that the start-time can be reported accurately,
     *         otherwise it should not be reported.
     *     </code>
     * </pre>
     *
     * @return {@code Timeticks64} startTime, guaranteed to be non-null.
     * @throws NoSuchElementException if startTime is not present
     *
     */
    default @NonNull Timeticks64 requireStartTime() {
        return CodeHelpers.require(getStartTime(), "starttime");
    }
    
    /**
     * Return cpuUsageUser, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         CPU time consumed by this process in user mode in nanoseconds.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} cpuUsageUser, or {@code null} if it is not present.
     *
     */
    Counter64 getCpuUsageUser();
    
    /**
     * Return cpuUsageUser, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         CPU time consumed by this process in user mode in nanoseconds.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} cpuUsageUser, guaranteed to be non-null.
     * @throws NoSuchElementException if cpuUsageUser is not present
     *
     */
    default @NonNull Counter64 requireCpuUsageUser() {
        return CodeHelpers.require(getCpuUsageUser(), "cpuusageuser");
    }
    
    /**
     * Return cpuUsageSystem, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         CPU time consumed by this process in kernel mode.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} cpuUsageSystem, or {@code null} if it is not present.
     *
     */
    Counter64 getCpuUsageSystem();
    
    /**
     * Return cpuUsageSystem, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         CPU time consumed by this process in kernel mode.
     *     </code>
     * </pre>
     *
     * @return {@code Counter64} cpuUsageSystem, guaranteed to be non-null.
     * @throws NoSuchElementException if cpuUsageSystem is not present
     *
     */
    default @NonNull Counter64 requireCpuUsageSystem() {
        return CodeHelpers.require(getCpuUsageSystem(), "cpuusagesystem");
    }
    
    /**
     * Return cpuUtilization, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The percentage of CPU that is being used by the process.
     *     </code>
     * </pre>
     *
     * @return {@code Percentage} cpuUtilization, or {@code null} if it is not present.
     *
     */
    Percentage getCpuUtilization();
    
    /**
     * Return cpuUtilization, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The percentage of CPU that is being used by the process.
     *     </code>
     * </pre>
     *
     * @return {@code Percentage} cpuUtilization, guaranteed to be non-null.
     * @throws NoSuchElementException if cpuUtilization is not present
     *
     */
    default @NonNull Percentage requireCpuUtilization() {
        return CodeHelpers.require(getCpuUtilization(), "cpuutilization");
    }
    
    /**
     * Return memoryUsage, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Bytes allocated and still in use by the process
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} memoryUsage, or {@code null} if it is not present.
     *
     */
    Uint64 getMemoryUsage();
    
    /**
     * Return memoryUsage, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Bytes allocated and still in use by the process
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} memoryUsage, guaranteed to be non-null.
     * @throws NoSuchElementException if memoryUsage is not present
     *
     */
    default @NonNull Uint64 requireMemoryUsage() {
        return CodeHelpers.require(getMemoryUsage(), "memoryusage");
    }
    
    /**
     * Return memoryUtilization, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The percentage of RAM that is being used by the process.
     *     </code>
     * </pre>
     *
     * @return {@code Percentage} memoryUtilization, or {@code null} if it is not present.
     *
     */
    Percentage getMemoryUtilization();
    
    /**
     * Return memoryUtilization, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The percentage of RAM that is being used by the process.
     *     </code>
     * </pre>
     *
     * @return {@code Percentage} memoryUtilization, guaranteed to be non-null.
     * @throws NoSuchElementException if memoryUtilization is not present
     *
     */
    default @NonNull Percentage requireMemoryUtilization() {
        return CodeHelpers.require(getMemoryUtilization(), "memoryutilization");
    }

}

