package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.remote.servers;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Host;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

/**
 * This class represents the key of {@link RemoteServer} class.
 *
 * @see RemoteServer
 *
 */
@Generated("mdsal-binding-generator")
public class RemoteServerKey
 implements Identifier<RemoteServer> {
    @java.io.Serial
    private static final long serialVersionUID = 1103321482008486332L;
    private final Host _host;


    /**
     * Constructs an instance.
     *
     * @param _host the entity host
     * @throws NullPointerException if any of the arguments are null
     */
    public RemoteServerKey(@NonNull Host _host) {
        this._host = CodeHelpers.requireKeyProp(_host, "host");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public RemoteServerKey(RemoteServerKey source) {
        this._host = source._host;
    }


    /**
     * Return host, guaranteed to be non-null.
     *
     * @return {@code Host} host, guaranteed to be non-null.
     */
    public @NonNull Host getHost() {
        return _host;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_host);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof RemoteServerKey other
            && Objects.equals(_host, other._host);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(RemoteServerKey.class);
        CodeHelpers.appendValue(helper, "host", _host);
        return helper.toString();
    }
}

