package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.types.rev210118;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform-types</b>
 * <pre>
 * typedef component-power-type {
 *   type enumeration {
 *     enum POWER_ENABLED {
 *     }
 *     enum POWER_DISABLED {
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public enum ComponentPowerType implements EnumTypeObject {
    /**
     * Enable power on the component
     */
    POWERENABLED(0, "POWER_ENABLED"),
    
    /**
     * Disable power on the component
     */
    POWERDISABLED(1, "POWER_DISABLED")
    ;

    private final @NonNull String name;
    private final int value;

    private ComponentPowerType(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding ComponentPowerType item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable ComponentPowerType forName(String name) {
        return switch (name) {
            case "POWER_ENABLED" -> POWERENABLED;
            case "POWER_DISABLED" -> POWERDISABLED;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding ComponentPowerType item, or {@code null} if no such item exists
     */
    public static @Nullable ComponentPowerType forValue(int intValue) {
        return switch (intValue) {
            case 0 -> POWERENABLED;
            case 1 -> POWERDISABLED;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding ComponentPowerType item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull ComponentPowerType ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding ComponentPowerType item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull ComponentPowerType ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
