package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.types.rev210118.COMPONENTOPERSTATUS;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.types.rev210118.OPENCONFIGHARDWARECOMPONENT;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.types.rev210118.OPENCONFIGSOFTWARECOMPONENT;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.Date;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.UnionTypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Operational state data for device components.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * grouping platform-component-state {
 *   leaf type {
 *     type union {
 *       type identityref {
 *         base OPENCONFIG_HARDWARE_COMPONENT;
 *       }
 *       type identityref {
 *         base OPENCONFIG_SOFTWARE_COMPONENT;
 *       }
 *     }
 *   }
 *   leaf id {
 *     type string;
 *   }
 *   leaf location {
 *     type string;
 *   }
 *   leaf description {
 *     type string;
 *   }
 *   leaf mfg-name {
 *     type string;
 *   }
 *   leaf mfg-date {
 *     type oc-yang:date;
 *   }
 *   leaf hardware-version {
 *     type string;
 *   }
 *   leaf firmware-version {
 *     type string;
 *   }
 *   leaf software-version {
 *     type string;
 *   }
 *   leaf serial-no {
 *     type string;
 *   }
 *   leaf part-no {
 *     type string;
 *   }
 *   leaf removable {
 *     type boolean;
 *   }
 *   leaf oper-status {
 *     type identityref {
 *       base COMPONENT_OPER_STATUS;
 *     }
 *   }
 *   leaf empty {
 *     type boolean;
 *     default false;
 *   }
 *   leaf parent {
 *     type leafref {
 *       path ../../../component/config/name;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface PlatformComponentState
    extends
    DataObject
{

    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
     * <pre>
     * leaf type {
     *   type union {
     *     type identityref {
     *       base OPENCONFIG_HARDWARE_COMPONENT;
     *     }
     *     type identityref {
     *       base OPENCONFIG_SOFTWARE_COMPONENT;
     *     }
     *   }
     * }
     * </pre>
     *
     */
    public static final class Type
     implements UnionTypeObject, Serializable {
        @java.io.Serial
        private static final long serialVersionUID = -5063863262481100039L;
        private final OPENCONFIGHARDWARECOMPONENT _oPENCONFIGHARDWARECOMPONENT;
        private final OPENCONFIGSOFTWARECOMPONENT _oPENCONFIGSOFTWARECOMPONENT;
    
    
        public Type(OPENCONFIGHARDWARECOMPONENT _oPENCONFIGHARDWARECOMPONENT) {
            this._oPENCONFIGHARDWARECOMPONENT = Objects.requireNonNull(_oPENCONFIGHARDWARECOMPONENT);
            this._oPENCONFIGSOFTWARECOMPONENT = null;
        }
        
        public Type(OPENCONFIGSOFTWARECOMPONENT _oPENCONFIGSOFTWARECOMPONENT) {
            this._oPENCONFIGHARDWARECOMPONENT = null;
            this._oPENCONFIGSOFTWARECOMPONENT = Objects.requireNonNull(_oPENCONFIGSOFTWARECOMPONENT);
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public Type(Type source) {
            this._oPENCONFIGHARDWARECOMPONENT = source._oPENCONFIGHARDWARECOMPONENT;
            this._oPENCONFIGSOFTWARECOMPONENT = source._oPENCONFIGSOFTWARECOMPONENT;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_oPENCONFIGHARDWARECOMPONENT != null) {
                return _oPENCONFIGHARDWARECOMPONENT.implementedInterface().toString();
            }
            if (_oPENCONFIGSOFTWARECOMPONENT != null) {
                return _oPENCONFIGSOFTWARECOMPONENT.implementedInterface().toString();
            }
            throw new IllegalStateException("No value assigned");
        }
    
    
        public OPENCONFIGHARDWARECOMPONENT getOPENCONFIGHARDWARECOMPONENT() {
            return _oPENCONFIGHARDWARECOMPONENT;
        }
        
        public OPENCONFIGSOFTWARECOMPONENT getOPENCONFIGSOFTWARECOMPONENT() {
            return _oPENCONFIGSOFTWARECOMPONENT;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_oPENCONFIGHARDWARECOMPONENT);
            result = prime * result + Objects.hashCode(_oPENCONFIGSOFTWARECOMPONENT);
            return result;
        }
    
        @Override
        public final boolean equals(Object obj) {
            return this == obj || obj instanceof Type other
                && Objects.equals(_oPENCONFIGHARDWARECOMPONENT, other._oPENCONFIGHARDWARECOMPONENT)        
                && Objects.equals(_oPENCONFIGSOFTWARECOMPONENT, other._oPENCONFIGSOFTWARECOMPONENT);
        }
    
        @Override
        public String toString() {
            final var helper = MoreObjects.toStringHelper(Type.class);
            CodeHelpers.appendValue(helper, "oPENCONFIGHARDWARECOMPONENT", _oPENCONFIGHARDWARECOMPONENT);
            CodeHelpers.appendValue(helper, "oPENCONFIGSOFTWARECOMPONENT", _oPENCONFIGSOFTWARECOMPONENT);
            return helper.toString();
        }
    }
    


    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("platform-component-state");

    @Override
    Class<? extends PlatformComponentState> implementedInterface();
    
    /**
     * Return type, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Type of component as identified by the system
     *     </code>
     * </pre>
     *
     * @return {@code Type} type, or {@code null} if it is not present.
     *
     */
    Type getType();
    
    /**
     * Return type, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Type of component as identified by the system
     *     </code>
     * </pre>
     *
     * @return {@code Type} type, guaranteed to be non-null.
     * @throws NoSuchElementException if type is not present
     *
     */
    default @NonNull Type requireType() {
        return CodeHelpers.require(getType(), "type");
    }
    
    /**
     * Return id, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Unique identifier assigned by the system for the component
     *     </code>
     * </pre>
     *
     * @return {@code String} id, or {@code null} if it is not present.
     *
     */
    String getId();
    
    /**
     * Return id, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Unique identifier assigned by the system for the component
     *     </code>
     * </pre>
     *
     * @return {@code String} id, guaranteed to be non-null.
     * @throws NoSuchElementException if id is not present
     *
     */
    default @NonNull String requireId() {
        return CodeHelpers.require(getId(), "id");
    }
    
    /**
     * Return location, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         System-supplied description of the location of the component within the system.
     *         This could be a bay position, slot number, socket location, etc. For component
     *         types that have an explicit slot-id attribute, such as linecards, the system
     *         should populate the more specific slot-id.
     *     </code>
     * </pre>
     *
     * @return {@code String} location, or {@code null} if it is not present.
     *
     */
    String getLocation();
    
    /**
     * Return location, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         System-supplied description of the location of the component within the system.
     *         This could be a bay position, slot number, socket location, etc. For component
     *         types that have an explicit slot-id attribute, such as linecards, the system
     *         should populate the more specific slot-id.
     *     </code>
     * </pre>
     *
     * @return {@code String} location, guaranteed to be non-null.
     * @throws NoSuchElementException if location is not present
     *
     */
    default @NonNull String requireLocation() {
        return CodeHelpers.require(getLocation(), "location");
    }
    
    /**
     * Return description, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         System-supplied description of the component
     *     </code>
     * </pre>
     *
     * @return {@code String} description, or {@code null} if it is not present.
     *
     */
    String getDescription();
    
    /**
     * Return description, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         System-supplied description of the component
     *     </code>
     * </pre>
     *
     * @return {@code String} description, guaranteed to be non-null.
     * @throws NoSuchElementException if description is not present
     *
     */
    default @NonNull String requireDescription() {
        return CodeHelpers.require(getDescription(), "description");
    }
    
    /**
     * Return mfgName, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         System-supplied identifier for the manufacturer of the component. This data is
     *         particularly useful when a component manufacturer is different than the overall
     *         device vendor.
     *     </code>
     * </pre>
     *
     * @return {@code String} mfgName, or {@code null} if it is not present.
     *
     */
    String getMfgName();
    
    /**
     * Return mfgName, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         System-supplied identifier for the manufacturer of the component. This data is
     *         particularly useful when a component manufacturer is different than the overall
     *         device vendor.
     *     </code>
     * </pre>
     *
     * @return {@code String} mfgName, guaranteed to be non-null.
     * @throws NoSuchElementException if mfgName is not present
     *
     */
    default @NonNull String requireMfgName() {
        return CodeHelpers.require(getMfgName(), "mfgname");
    }
    
    /**
     * Return mfgDate, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         System-supplied representation of the component's manufacturing date.
     *     </code>
     * </pre>
     *
     * @return {@code Date} mfgDate, or {@code null} if it is not present.
     *
     */
    Date getMfgDate();
    
    /**
     * Return mfgDate, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         System-supplied representation of the component's manufacturing date.
     *     </code>
     * </pre>
     *
     * @return {@code Date} mfgDate, guaranteed to be non-null.
     * @throws NoSuchElementException if mfgDate is not present
     *
     */
    default @NonNull Date requireMfgDate() {
        return CodeHelpers.require(getMfgDate(), "mfgdate");
    }
    
    /**
     * Return hardwareVersion, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         For hardware components, this is the hardware revision of the component.
     *     </code>
     * </pre>
     *
     * @return {@code String} hardwareVersion, or {@code null} if it is not present.
     *
     */
    String getHardwareVersion();
    
    /**
     * Return hardwareVersion, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         For hardware components, this is the hardware revision of the component.
     *     </code>
     * </pre>
     *
     * @return {@code String} hardwareVersion, guaranteed to be non-null.
     * @throws NoSuchElementException if hardwareVersion is not present
     *
     */
    default @NonNull String requireHardwareVersion() {
        return CodeHelpers.require(getHardwareVersion(), "hardwareversion");
    }
    
    /**
     * Return firmwareVersion, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         For hardware components, this is the version of associated firmware that is
     *         running on the component, if applicable.
     *     </code>
     * </pre>
     *
     * @return {@code String} firmwareVersion, or {@code null} if it is not present.
     *
     */
    String getFirmwareVersion();
    
    /**
     * Return firmwareVersion, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         For hardware components, this is the version of associated firmware that is
     *         running on the component, if applicable.
     *     </code>
     * </pre>
     *
     * @return {@code String} firmwareVersion, guaranteed to be non-null.
     * @throws NoSuchElementException if firmwareVersion is not present
     *
     */
    default @NonNull String requireFirmwareVersion() {
        return CodeHelpers.require(getFirmwareVersion(), "firmwareversion");
    }
    
    /**
     * Return softwareVersion, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         For software components such as operating system or other software module, this
     *         is the version of the currently running software.
     *     </code>
     * </pre>
     *
     * @return {@code String} softwareVersion, or {@code null} if it is not present.
     *
     */
    String getSoftwareVersion();
    
    /**
     * Return softwareVersion, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         For software components such as operating system or other software module, this
     *         is the version of the currently running software.
     *     </code>
     * </pre>
     *
     * @return {@code String} softwareVersion, guaranteed to be non-null.
     * @throws NoSuchElementException if softwareVersion is not present
     *
     */
    default @NonNull String requireSoftwareVersion() {
        return CodeHelpers.require(getSoftwareVersion(), "softwareversion");
    }
    
    /**
     * Return serialNo, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         System-assigned serial number of the component.
     *     </code>
     * </pre>
     *
     * @return {@code String} serialNo, or {@code null} if it is not present.
     *
     */
    String getSerialNo();
    
    /**
     * Return serialNo, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         System-assigned serial number of the component.
     *     </code>
     * </pre>
     *
     * @return {@code String} serialNo, guaranteed to be non-null.
     * @throws NoSuchElementException if serialNo is not present
     *
     */
    default @NonNull String requireSerialNo() {
        return CodeHelpers.require(getSerialNo(), "serialno");
    }
    
    /**
     * Return partNo, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         System-assigned part number for the component. This should be present in
     *         particular if the component is also an FRU (field replaceable unit)
     *     </code>
     * </pre>
     *
     * @return {@code String} partNo, or {@code null} if it is not present.
     *
     */
    String getPartNo();
    
    /**
     * Return partNo, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         System-assigned part number for the component. This should be present in
     *         particular if the component is also an FRU (field replaceable unit)
     *     </code>
     * </pre>
     *
     * @return {@code String} partNo, guaranteed to be non-null.
     * @throws NoSuchElementException if partNo is not present
     *
     */
    default @NonNull String requirePartNo() {
        return CodeHelpers.require(getPartNo(), "partno");
    }
    
    /**
     * Return removable, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         If true, this component is removable or is a field replaceable unit
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} removable, or {@code null} if it is not present.
     *
     */
    Boolean getRemovable();
    
    /**
     * Return removable, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         If true, this component is removable or is a field replaceable unit
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} removable, guaranteed to be non-null.
     * @throws NoSuchElementException if removable is not present
     *
     */
    default @NonNull Boolean requireRemovable() {
        return CodeHelpers.require(getRemovable(), "removable");
    }
    
    /**
     * Return operStatus, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         If applicable, this reports the current operational status of the component.
     *     </code>
     * </pre>
     *
     * @return {@code COMPONENTOPERSTATUS} operStatus, or {@code null} if it is not present.
     *
     */
    COMPONENTOPERSTATUS getOperStatus();
    
    /**
     * Return operStatus, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         If applicable, this reports the current operational status of the component.
     *     </code>
     * </pre>
     *
     * @return {@code COMPONENTOPERSTATUS} operStatus, guaranteed to be non-null.
     * @throws NoSuchElementException if operStatus is not present
     *
     */
    default @NonNull COMPONENTOPERSTATUS requireOperStatus() {
        return CodeHelpers.require(getOperStatus(), "operstatus");
    }
    
    /**
     * Return empty, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The empty leaf may be used by the device to indicate that a component position
     *         exists but is not populated. Using this flag, it is possible for the management
     *         system to learn how many positions are available (e.g., occupied vs. empty
     *         linecard slots in a chassis).
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} empty, or {@code null} if it is not present.
     *
     */
    Boolean getEmpty();
    
    /**
     * Return empty, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The empty leaf may be used by the device to indicate that a component position
     *         exists but is not populated. Using this flag, it is possible for the management
     *         system to learn how many positions are available (e.g., occupied vs. empty
     *         linecard slots in a chassis).
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} empty, guaranteed to be non-null.
     * @throws NoSuchElementException if empty is not present
     *
     */
    default @NonNull Boolean requireEmpty() {
        return CodeHelpers.require(getEmpty(), "empty");
    }
    
    /**
     * Return parent, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Reference to the name of the parent component. Note that this reference must be
     *         kept synchronized with the corresponding subcomponent reference from the parent
     *         component.
     *     </code>
     * </pre>
     *
     * @return {@code Object} parent, or {@code null} if it is not present.
     *
     */
    Object getParent();
    
    /**
     * Return parent, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Reference to the name of the parent component. Note that this reference must be
     *         kept synchronized with the corresponding subcomponent reference from the parent
     *         component.
     *     </code>
     * </pre>
     *
     * @return {@code Object} parent, guaranteed to be non-null.
     * @throws NoSuchElementException if parent is not present
     *
     */
    default @NonNull Object requireParent() {
        return CodeHelpers.require(getParent(), "parent");
    }

}

