package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.top;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.DebugMessagesTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.debug.messages.top.DebugEntries;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.top.messages.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.top.messages.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Messages} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Messages createMessages(int fooXyzzy, int barBaz) {
 *         return new MessagesBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Messages, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Messages
 *
 */
@Generated("mdsal-binding-generator")
public class MessagesBuilder {

    private Config _config;
    private DebugEntries _debugEntries;
    private State _state;


    Map<Class<? extends Augmentation<Messages>>, Augmentation<Messages>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public MessagesBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link DebugMessagesTop}.
     *
     * @param arg DebugMessagesTop from which the builder should be initialized
     */
    public MessagesBuilder(DebugMessagesTop arg) {
        this._debugEntries = arg.getDebugEntries();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Messages}.
     *
     * @param base Messages from which the builder should be initialized
     */
    public MessagesBuilder(Messages base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._config = base.getConfig();
        this._debugEntries = base.getDebugEntries();
        this._state = base.getState();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link DebugMessagesTop}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DebugMessagesTop castArg) {
            this._debugEntries = castArg.getDebugEntries();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[DebugMessagesTop]");
    }

    private static final class LazyEmpty {
        static final @NonNull Messages INSTANCE = new MessagesBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of Messages.
     *
     * @return An empty {@link Messages}
     */
    public static @NonNull Messages empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link Messages#getConfig()}.
     *
     * @return current value
     */
    public Config getConfig() {
        return _config;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Messages#getDebugEntries()}.
     *
     * @return current value
     */
    public DebugEntries getDebugEntries() {
        return _debugEntries;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Messages#getState()}.
     *
     * @return current value
     */
    public State getState() {
        return _state;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Messages>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Messages#getConfig()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public MessagesBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Messages#getDebugEntries()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public MessagesBuilder setDebugEntries(final DebugEntries value) {
        this._debugEntries = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Messages#getState()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public MessagesBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public MessagesBuilder addAugmentation(Augmentation<Messages> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public MessagesBuilder removeAugmentation(Class<? extends Augmentation<Messages>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Messages} instance.
     *
     * @return A new {@link Messages} instance.
     */
    public @NonNull Messages build() {
        return new MessagesImpl(this);
    }

    private static final class MessagesImpl
        extends AbstractAugmentable<Messages>
        implements Messages {
    
        private final Config _config;
        private final DebugEntries _debugEntries;
        private final State _state;
    
        MessagesImpl(MessagesBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._debugEntries = base.getDebugEntries();
            this._state = base.getState();
        }
    
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public DebugEntries getDebugEntries() {
            return _debugEntries;
        }
        
        @Override
        public State getState() {
            return _state;
        }
    
        @Override
        public Config nonnullConfig() {
            return Objects.requireNonNullElse(getConfig(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.top.messages.ConfigBuilder.empty());
        }
        
        @Override
        public DebugEntries nonnullDebugEntries() {
            return Objects.requireNonNullElse(getDebugEntries(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.debug.messages.top.DebugEntriesBuilder.empty());
        }
        
        @Override
        public State nonnullState() {
            return Objects.requireNonNullElse(getState(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.top.messages.StateBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Messages.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Messages.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Messages.bindingToString(this);
        }
    }
}
